/**************************************************************************
 * CommOpt - Functions for the make of the options of the command line. 
 * Version:     0.3.7 20/02/2006
 * File:        CommOpt.c
 * Description: Functions for the reading, verification, execution of the 
 *              options of the command line. 
 * Error:       ID file 2, last number 04
 * Platform(s):	GNU/Linux, All
 * Author(s):	Della Bianca Giuseppe <bepi@adria.it><bepii@libero.it>
 *
 * Copyright (C) 2002-6 Della Bianca Giuseppe <bepi@adria.it><bepii@libero.it>
 * This file is part of GesConf.
 *
 * GesConf is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * GesConf is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GesConf; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 **************************************************************************/
#include <limits.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#define _EL_PRIVATE_H
#define _CO_PRIVATE_H
#include "ErrLog.h"
#include "CommOpt.h"
#include "BaseString.h"
#include "file.h"
#include "global.h"
#include "descr.h"

// variable for the management of the command line options
struct _CommPar CommPar;

static char *StrNull= "";

/**************************************************************************
 * Function: CoExeOpts
 * Details:  Execute the options.
 * Returns: 
 **************************************************************************/
int CoExeOpts (){

  int result= true, NiceLNum, OptLNum;

// executes the options
  if (CommPar.argc > 1){
    for (NiceLNum= 0; NiceLNum < CommPar.NumOptL && result; NiceLNum++){
      OptLNum= CommPar.NiceOptL[NiceLNum];
// executes user ExeOpt
      if (CommPar.ListOpt[OptLNum].ID >= 0 && CommPar.pfExeOpt != NULL)
	  result= CommPar.pfExeOpt (OptLNum);
    } // for (NiceLNum= 0; NiceLNum < NumOptL && result; NiceLNum++)
  }

  return (result);
} // CoExeOpts

/**************************************************************************
 * Function: CoRedOpts
 * Details:  Reads and check the options
 * Returns: 
 **************************************************************************/
int CoReadOpts (){

  int result= true;

// make the options of the command line 
  if (CommPar.argc > 1)
// translate of the arguments in options and verify of the options 
    result= ParsArgv ();

  return (result);
} // CoReadOpts

/**************************************************************************
 * Function: CoPrintOpts
 * Details:  Print the options list
 * Returns: 
 **************************************************************************/
void CoPrintOpts (){

  int OptNum, LenOpt, LenLargeOpt, MaxLOpt, MaxLLargeOpt;
  struct _OptData *ActOData;

// set the maximun lenght of the options
  MaxLOpt= MaxLLargeOpt= 0;
  for (OptNum= 0; ActOData= (struct _OptData *)&CommPar.OptData[OptNum], 
	 *ActOData->opt != '\0'; OptNum++){
    LenOpt= strlen (ActOData->opt);
    LenLargeOpt= strlen (ActOData->LargeOpt);
    if (LenOpt > MaxLOpt)
      MaxLOpt= LenOpt;
    if (LenLargeOpt > MaxLLargeOpt)
      MaxLLargeOpt= LenLargeOpt;
  }
// print the options
  printf ("%s\n%s\n\n", PACKAGE_STRING, _(DESCPRIG));
  printf (_(" Usage:\n"));
  for (OptNum= 0; ActOData= (struct _OptData *)&CommPar.OptData[OptNum], 
	 *ActOData->opt != '\0'; OptNum++){
// print the option
    if (*ActOData->opt == '-')
      printf ("   %-*s", MaxLOpt, ActOData->opt); 
    else
      printf ("  -%-*s", MaxLOpt, ActOData->opt);
// print large option
    if  (*ActOData->LargeOpt == '\0')
      printf ("    %-*s", MaxLLargeOpt, "");
    else
      printf ("  --%-*s", MaxLLargeOpt, ActOData->LargeOpt);
// print description of the option
    printf ("  %s\n", _(ActOData->des));
  }
  printf (_(DESINFO));

} // CoPrintOpts

/**************************************************************************
 * Function: CoUpdArg
 * Details:  Update option*parameter) with argument
 * Returns:
 **************************************************************************/
void CoUpdArg (struct _OptImp *ArgOptL, char *arg){

  int StartOpt, UpdAbil;
  struct _OptImp RealOptL;

// update the option/parameter with argument
  StartOpt= 0;
  UpdAbil= true;
  OptLFromArg (ArgOptL, &RealOptL, arg, &StartOpt, &UpdAbil);

} // CoUpdArg

/**************************************************************************
 * Function: CoInit
 * Details:  Initialize the parameters of the configuration
 * Returns: 
 **************************************************************************/
void CoInit (){

  CommPar.argv= NULL;
  CommPar.argc= 0;
  CommPar.MultOptDisab= false;
  CommPar.OptData= NULL;
  CommPar.pfExeCheckOpt= NULL;
  CommPar.pfExeOpt= NULL;
} //CoInit

/**************************************************************************
 * Function: ParsArgv
 * Details:  Executes the parsing of the argv
 * Returns: 
 **************************************************************************/
static int ParsArgv (){
 
  int result= true, ArgNum, StartOpt, UpdAbil, OptNum, NiceLNum, OptLNum, StepNum;
  char str[LENSTR + 1], *arg;
  struct _OptImp ArgOptL, *RealOptL, *ActOptL;

// translate the arguments in options/parameters and add it in the list of the options
  CommPar.NumOptL= 0;
  RealOptL= NULL;
  for (ArgNum= 1; ArgNum < CommPar.argc && result; ArgNum++){
    arg= CommPar.argv[ArgNum];
    StartOpt= 0;
    do{ // while (arg[StartOpt] != '\0')
      if (CommPar.NumOptL >= MAXNOPT){
	result= false;
	sprintf(str, "%d", MAXNOPT);
	ElAddErr2 (201, "BO", _("With %s the number of argument exceeds %s"), arg, str);
	break;
      }
// parsing multiple option (ex. -vi is -v -i) and set the option/parameter
      UpdAbil= false;
      OptNum= OptLFromArg (&ArgOptL, RealOptL, arg, &StartOpt, &UpdAbil);
      if (UpdAbil && RealOptL != NULL)
	ActOptL= RealOptL;
      else{
	ActOptL= &CommPar.ListOpt[CommPar.NumOptL];
	if (ArgOptL.ID >= 0)
	  RealOptL= &CommPar.ListOpt[CommPar.NumOptL];
/* the sequence of executions of the options is initially equal to the sequence 
   of insertion */
	CommPar.NiceOptL[CommPar.NumOptL]= CommPar.NumOptL;
	CommPar.NumOptL++;
      }
// set the data of new option/parameter
      *ActOptL= ArgOptL;
      if (OptNum >= 0){
	ActOptL->OptArgN= ArgNum;
	StartOpt= StartOpt + ActOptL->OptLen;
      }
      else{
	ActOptL->ParArgN= ArgNum;
	StartOpt= StartOpt + strlen (ActOptL->ParArg);
      }
    }while (arg[StartOpt] != '\0');
  } // for (ArgNum= 1; ArgNum < ArgcIn; ArgNum++)

// set the order of processing of the list options
  if (result)
    qsort (CommPar.NiceOptL, CommPar.NumOptL, sizeof (*CommPar.NiceOptL), (int (*) (const void *, const void *)) OptLCmp);

// verify the option
  for (StepNum= 0; StepNum < 3 && result; StepNum++){
    for (NiceLNum= 0; NiceLNum < CommPar.NumOptL && result; NiceLNum++){
      OptLNum= CommPar.NiceOptL[NiceLNum];
      ActOptL= &CommPar.ListOpt[OptLNum];
/* if is an option or is a parameter not assigned to one option (without priority)
   and therefore to process */
      if (result && (ActOptL->ID != -1 || ActOptL->nice < 0)){
	switch (StepNum){
	case 1:
// execute user ExeCheckOpt step 1 (before the verification of the sintax of the options)
	  if (CommPar.pfExeCheckOpt != NULL)
	    result= CommPar.pfExeCheckOpt (OptLNum, 1);
	  break;
	case 2:
// verify the option
	  result= CheckOpt (OptLNum) >= 0;
	  break;
	case 3:
// execute user ExeCheckOpt step 2 (after the verification of the sintax of the options)
	  if (CommPar.pfExeCheckOpt != NULL)
	    result= CommPar.pfExeCheckOpt (OptLNum, 2);
	  break;
	}
      }
    } // for (NiceLNum= 0; NiceLNum < NumOptL && result; NiceLNum++)
  } // for (StepNum= 0; StepNum < 3 && result; StepNum++)

// set the order of processing of the list options and of the relative parameters 
  if (result)
    qsort (CommPar.NiceOptL, CommPar.NumOptL, sizeof (*CommPar.NiceOptL), (int (*) (const void *, const void *)) OptLCmp);

  return (result);
} // ParsArgv

/**************************************************************************
 * Function: OptLFromArg
 * Details:  Setup the option list from arguments/parameters
 * Returns:  Return the number of the  option
 **************************************************************************/
static int OptLFromArg (struct _OptImp *ArgOptL, struct _OptImp *RealOptL, char *OptArg, int *StartOpt, int *UpdArg){

  int OptNum, OptID, LargeOpt, UpdPar, NumPar, MaxNumPar, ParNum;
  struct _OptImp *ActOptL;

  NumPar= 0;
  MaxNumPar= -1;
  OptNum= OptID= GetOpt (OptArg, StartOpt, &LargeOpt);
// set the data for required update option/parameters
  UpdPar= OptNum >= 0 && *UpdArg;
  ActOptL= UpdPar ? RealOptL : ArgOptL;
// if is one option
  if (OptNum >= 0){
    if (!*UpdArg)
      RealOptL= NULL;
// set the option
    OptLFromData (ActOptL, OptNum, LargeOpt);
    ActOptL->OptArg= &OptArg[*StartOpt];
  } // if (OptNum >= 0)
// if is one parameter (or invalid options)
  if (OptNum < 0 || UpdPar){
    if (!UpdPar){
      ArgOptL->OptArgN= ArgOptL->ParArgN= 0;
      ArgOptL->OptArg= StrNull;
      ArgOptL->ParArg= &OptArg[*StartOpt];
      ArgOptL->OptLen= 0;
    }
    ArgOptL->opt= StrNull;
    ArgOptL->OptNum= OptNum;
    ArgOptL->NumPar= 0;
    ArgOptL->ID= OptID;
    if ((OptNum == -1 || UpdPar) && RealOptL != NULL){
// set the actual option
      NumPar= RealOptL->NumPar + 1;
      MaxNumPar= (RealOptL->MaxNPar > RealOptL->MinNPar) ? RealOptL->MaxNPar : RealOptL->MinNPar;
    }
// if the parameter is of the actual option
    if (NumPar <= MaxNumPar){
      if (NumPar == 1)
	*UpdArg= true;

      ArgOptL->opt= RealOptL->opt;
      ArgOptL->OptNum= RealOptL->OptNum;
      ArgOptL->MinNPar= RealOptL->MinNPar;
      ArgOptL->MaxNPar= RealOptL->MaxNPar;
      ArgOptL->NumPar= NumPar;
      ArgOptL->nice= RealOptL->nice;
      if (*UpdArg){
	ArgOptL->OptArgN= RealOptL->OptArgN;
	ArgOptL->OptArg= RealOptL->OptArg;
	ArgOptL->OptLen= RealOptL->OptLen;
	ArgOptL->ID= RealOptL->ID;
      }
// update the option and the others parameters of the option
      for (ParNum= 0; ParNum < NumPar; ParNum++)
	RealOptL[ParNum].NumPar= NumPar;
    }
    else{
      RealOptL= NULL;
      ArgOptL->MinNPar= ArgOptL->MaxNPar= 0;
      ArgOptL->nice= -1;
    }
  } // if (OptNum < 0 || UpdPar)

  return (OptNum);
} // OptLFromArg

/**************************************************************************
 * Function: OptLFromData
 * Details:  Setup the option list from data option
 * Returns:
 **************************************************************************/
static void OptLFromData (struct _OptImp *ActOptL, int OptNum, int LargeOpt){

  char *opt;
  struct _OptData *ActOData;

  ActOData= (struct _OptData*)&CommPar.OptData[OptNum];

  opt= LargeOpt ? ActOData->LargeOpt : ActOData->opt;
// set the option
  ActOptL->OptArgN= ActOptL->ParArgN= 0;
  ActOptL->OptArg= ActOptL->ParArg= StrNull;
  ActOptL->OptLen= strlen (opt);
  ActOptL->opt= opt;
  ActOptL->OptNum= OptNum;
  ActOptL->MinNPar= ActOData->MinNPar;
  ActOptL->MaxNPar= ActOData->MaxNPar;
  ActOptL->NumPar= 0;
  ActOptL->nice= ActOData->nice;
  ActOptL->ID= ActOData->ID;

} // OptLFromData

/**************************************************************************
 * Function: GetOpt
 * Details:  Verify if is one option and return the number of the option
 * Returns:  >= 0 is one option, -1 is not one option, -2 option is not 
 *           managed.
 **************************************************************************/
static int GetOpt (char *arg, int *StartOpt, int *LargeOpt){

  int result, OptAbil, OptNum, StartCheck, LenOpt, FindOpt;
  char *opt;
  struct _OptData *ActOData;

  result= StartCheck= -1;
  OptAbil= *LargeOpt= false;
// verify if the argument begins with one option
  if (!strncmp (arg, "--", 2)){
    *LargeOpt= true;
    StartCheck= 2;
  }
  else if (!strncmp (arg, "-", 1)){
    if (strlen (arg) > 1)
      StartCheck= 1;
    else
      StartCheck= 0;
  }
// if the argument begins with one option
  if (StartCheck >= 0){
    OptAbil= true;
// if is specified of control a part of one multiple option (ex. -vi is -v -i)
    if (StartCheck > *StartOpt)
      *StartOpt= StartCheck;
// if the part in parsing is not one option
    if (arg[*StartOpt] == '='){
      OptAbil= false;
      (*StartOpt)++;
    }
  } // if (StartCheck >= 0)
// verify that the option is one of the managed options
  if (OptAbil){
    result= -2;
    if (CommPar.OptData != NULL){
      for (OptNum= 0; ActOData= (struct _OptData*)&CommPar.OptData[OptNum], *ActOData->opt != '\0'; OptNum++){
	opt= *LargeOpt ? ActOData->LargeOpt : ActOData->opt;
	LenOpt= strlen (opt);
	if (*opt != '\0'){
	  FindOpt= false;
	  if (CommPar.MultOptDisab)
	    FindOpt= !strcmp (opt, &arg[*StartOpt]);
	  else
	    FindOpt= !strncmp (opt, &arg[*StartOpt], LenOpt);
	  if (FindOpt){
	    result= OptNum;
	    break;
	  }
	} // if (*opt != '\0')
      } // for (OptNum= 0; ActOData= (struct _OptData*)&CommPar.OptData[OptNum], *ActOData->opt != '\0'; OptNum++)
    } // if (CommPar.OptData) != NULL
  } // if (OptAbil)

  return (result);
} // GetOpt

/**************************************************************************
 * Function: CheckOpt
 * Details:  Verify the option
 * Returns:  >= 0 is one option, -1 is not one option, -2 option is not 
 *           managed, -3 wrong parameters.
 **************************************************************************/
static int CheckOpt (int OptLNum){

  int result, NumPar;
  char *opt, *par;
  struct _OptImp *ActOptL;

  ActOptL= &CommPar.ListOpt[OptLNum];
  NumPar= ActOptL->MinNPar;
  result= ActOptL->ID;
  opt= ActOptL->OptArg;
  par= ActOptL->ParArg;
  if (result >= 0){
    if (ActOptL->OptArgN == 0)
      opt= par;
// verify if the option is complete
    if (NumPar > 0 && ActOptL->NumPar < ActOptL->MinNPar)
      result= -3;
  }

  switch (result){
  case -1:
    ElAddErr1 (202, "BO", _("The option <%s> is invalid"), par);
    break;
  case -2:
    ElAddErr1 (203, "BO", _("The option <%s> is not managed"), par);
    break;
  case -3:
    ElAddErr1 (204, "BO", _("The option <%s> is incomplete"), opt);
    break;
  } // switch (result)

  return (result);
} // CheckOpt

/**************************************************************************
 * Function: OptLCmp
 * Details:  Compare the options in base to the priority and the order of 
 *           the arguments.
 * Returns: 
 **************************************************************************/
static int OptLCmp (const int *val1, const int *val2){

  int result;
  struct _OptImp *ActOptL1, *ActOptL2;

  ActOptL1= &CommPar.ListOpt[*val1];
  ActOptL2= &CommPar.ListOpt[*val2];

  result= (ActOptL1->nice == ActOptL2->nice ? 0 : ActOptL1->nice < ActOptL2->nice ? 1 : -1);
  if (result == 0)
    result= (*val1 == *val1? 0 : *val1 < *val2 ? 1 : -1);

  return (result);
} // OptLCmp
