#!/usr/bin/perl
# $Id: mplayer.pl,v 1.37 2006/09/21 18:20:53 khlut Exp $
# Bind mplayer and mencoder with HTML object
# ElphelOgm is used to receive and record rtp mjpeg video
#
# Copyright 2005 Elphel, Inc.
#
# This file is part of GenReS.
#
#    GenReS is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    GenReS is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with GenReS; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

use IPC::Open2;
use threads;
use threads::shared;
use POSIX ":sys_wait_h";
use Gtk2 -init;

## Parameters from the config file ##
$conffile="$ENV{HOME}/.mozilla/genres/mplayer.conf";
$filehelp=
     "%@  in the filename will be replaced to source URL\n"
    ."%Y - year \t%m - month number\t%d - day of month\n"
    ."%H - hour \t%M - minute  \t%S - second\n"
    ."\$n - number of frames in the file\n"
    ."\$t - timestamp of the last frame";
%cfg=(
  vo=>[x11, 'text', "Video output driver (see mplayer -vo help)"],
  ao=>["esd,arts,oss,alsa", 'text', "Audio output driver (see mplayer -ao help)"],
  not_ask=> [0, 'checkbox', "Never show file save dialog again."],
  not_ask_jpegs=> [0, 'checkbox', "Never show save as jpegs dialog again."],
  out_file_once=>['%@-%Y-%m-%d_%H-%M-%S.avi', 'file', "Save this video to file", $filehelp],
  out_file=>     ['%@-%Y-%m-%d_%H-%M-%S.avi', 'file', "Write video to file(s)", $filehelp],
  out_file_jpegs=>     ['%@-%Y-%m-%d_%H-%M-\$t.jpeg', 'file', "Save this video to jpeg files", $filehelp],
  out_file_jpegs_auto=>['%@-%Y-%m-%d_%H-%M-\$t.jpeg', 'file', "Write video to jpeg files", $filehelp],
  frames=> [10000, 'text', "Frames per file limit"],
);
$_=$0;  s|[^/]*$||;  @INC=( "$_../..",@INC);
require "config.pl";
load_config();
## *** ##

$v{quittimeout}=2; #wait 2 seconds after send quit command or interruptable signal
$v{play}=1;
$v{flip}=0;
$v{mirror}=0;
$loop=1;
$href="/dev/fd/3";
# output window
$gc=undef;# GDK graphic context
$w=undef; # window width
$W=undef; # GDK window
###

$|=1; #forces a flush right away and after every write or print on the currently selected output channel
my $shutstate:shared=0;
my $pausestate:shared=0;
my $queue:shared="";
my $thrid:shared;

$^F=100; #to pass pipe to new processes
pipe PIPE_OUT, PIPE_IN;

sub localnet {
    return $v{href}=~m!file://! || $v{href}=~m![a-zA-Z0-9]+://(127|192|10|172|232)\.! ;
}
sub gettimeout {
    return localnet() ? 10 : 100;
}
sub progress {
    return unless $W ;
    $W->draw_rectangle ($gc, 1 , 0, 0, $w*$_[0]/50, 10);
    Gtk2::Gdk->flush;
}

sub shut{
    lock $queue,$shutstate;
    !$shutstate++ && $v{save} && $shutstate++;
    alarm $v{quittimeout};
    if($shutstate==1){		#interrupt read
	print SLVW "\nquit\n";
	close(PIPE_IN);
    }elsif($shutstate==2){	#tell mplayer to shut
        kill 2 => $slvp;
	kill 2 => $sl2p if $sl2p;
    }else{			#if it again not respond kill it
        kill -9 => $slvp;
	kill(-9 => $sl2p) || print "kill_error: $!\n" if $sl2p;
#	print "\nrun=0\n";    
	exit 0;	
    }
    return;
}

sub normal_exit{
    $SIG{PIPE}='IGNORE';
    lock $queue,$shutstate;
    alarm ($shutstate? $v{'quittimeout'} : gettimeout);
    print "\nDESTROY\n";
    close(PIPE_IN);
    close(PIPE_OUT);
    waitpid $slvp, 0;
    waitpid $slvp, 0;
    waitpid $slvp, 0;
    if(waitpid($slvp, 0)<0 && kill(0,$slvp)>0 && threads->self->tid == $thrid) {
	alarm 0;
	return;
    }
    if($sl2p) {
	kill 9 => $sl2p;
	waitpid $sl2p, 0;
    }
#    print "\nrun=0\n";
    exit 0;
}

$SIG{PIPE}=\&normal_exit;
$SIG{ALRM}=\&shut;

sub url2mplayer {
    if( $v{href} =~ m|^/| ) {
	if($v{baseURI} !~ m|^file://| && $v{baseURI} =~ m|^[a-zA-Z0-9]+://[^/]/|) {
	    $v{href}=$&.$v{href};
	}
    }else{
	$v{href}=$v{baseURI}.'/'.$v{href}	if( $v{href}!~m|[a-zA-Z0-9]+:| );
    }
    $href=$v{href};
    if($ENV{GENRES_MOZILLA_STREAMS} && $v{src} && $href=~m!^(http.?|ftp.?)://!) {
	$href="/dev/fd/3";
    }else{
	$href=~s|^file://||;
    }
}
sub cmd {
    my ($c)=@_;
    my ($var,$val) = split '=', $c, 2;
    $val=~s/\n//;
    if( $c eq "run=0\n" ) {
        shut();
        return;
    }elsif( $c eq "EOF\n" ) {
	lock $queue;
	if($href eq "/dev/fd/3" && ($loop==0 || $loop>1)) {
    	    print "OPEN\n";
	    $loop-- if($loop);
        }else{
    	    print "CLOSE\n";
	}
    }elsif( $var eq "pause" ) {
        $val=0+$val;
        $val=1 if $val!=0 && $val!=1 ;
        if($val != $pausestate) {
    	    $pausestate=$val;
    	    print SLVW "pause\n";
    	    lock $queue;
    	    $queue.="pause=$val\nplay=".(1-$val)."\n";
	}	    
    }elsif( $var eq "play" ) {
        $val=0+$val;
        $val=1 if $val!=0 && $val!=1 ;
        $val=1-$val;
        if($val != $pausestate) {
    	    $pausestate=$val;
    	    print SLVW "pause\n";
    	    lock $queue;
    	    $queue.="pause=$val\nplay=".(1-$val)."\n";
	}	    
    }elsif( $var eq "filepos" ) {
	if($val =~ /^[-+]/) {
    	    print SLVW "seek $val 0\n";	
        }elsif($val =~ s/%//) {
    	    print SLVW "seek $val 1\n";
        }else{
	    print SLVW "seek $val 2\n";
        }
        $pausestate=0;
    }elsif( $var eq "framestep" ) {
        print SLVW "frame_step\n";	    
        $pausestate=1;
        lock $queue;
        $queue.="pause=1\nplay=0\n";
    }elsif( $var eq "src" or $var eq "href") {
        $v{$var}=$val;
        $v{href}=$val;
	my $prhref=$href;
        url2mplayer();
        print SLVW "loadfile $href\n" if $href ne $prhref || $href ne '/dev/fd/3';
        lock $queue;
        $queue.="src=$val\nhref=$val\n";
	if($prhref eq '/dev/fd/3') {
	    $queue.="DESTROY\n"; # destroy old stream
	}
	if($href eq '/dev/fd/3') {
	    $queue.="OPEN\n"; # open new stream	    
	}
    }elsif($c !~ /.*=/) { # unimplemented command
	lock $queue;
	$queue.="error=1\n";
    }else{
        $v{$var}=$val;
        lock $queue;
        $queue.="$c";
    }
}
sub ifilt{
    
    cmd("pause=1") 		    if $v{pause} || !$v{play};
    cmd("filepos=$v{filepos}")      if $v{filepos};
    cmd("framestep=$v{framestep}")  if $v{framestep};
    while(<STDIN>){
	cmd($_);
    }
}

sub ofilt_quit{ #child hangs
    $SIG{ALRM}=\&shut;
    kill ALRM, $ifilt;
}

sub ofilt{
    local $s;
    local $SIG{ALRM}=\&ofilt_quit;
    alarm gettimeout;
    $s="";
    print "run=1\n";
    do {
      while($_='', sysread( SLVR, $_, 1 ) || $!{EINTR}){
	if( tr/\r/\n/ ){
	    alarm($pausestate? 0 : gettimeout);
	}
	$s.=$_;
	{lock $queue;
	  if($queue ne "") {
	    print $queue;
	    $queue="";
	  }
	}
	if($_ eq "\n") {{
	    lock $queue;
	    if( $s =~ 'Failed' ) {
	        print "error=$s";
	    }elsif($s =~ m/^Playing (.*)\.$/){
		$s=$1;
		if($s !~ m!-|/dev!) {
		    $s="file://".$s if $s !~ m|^[a-z0-9]*://|;
		    print "url=$s";
		}else{
		    print "url=$v{href}\n";
		}
	    }elsif($s =~ m/^Cache fill:[[:space:]]*([0-9.]*)%/){
		progress($1);
		print "cachefill=".substr($s,11);
	    }elsif($s =~ m/^Connecting to/){
		print "status=$s";
	    }elsif($s =~ m/^[AV]:/ || $s =~ m/^Pos:/){
		$s =~ s/ \033\[J$//;
		print "frame=$s";
	    }else{
		print $s;
	    }
	    $s="";
	}}
      }
    }while($restart && !$shutstate && $restart && &$restart);
    ofilt_quit() unless $SIG{ALRM} eq \&shut;;
    normal_exit();
}
sub runslv{
    $slvp = open2(*SLVR, *SLVW, "exec @_ 2>&1");
}
sub suburl{
    local $_=$v{href};
    s|^[a-z0-9]*://||i;
    s|[?].*||;
    s|/|-|g;
    s/^-+//;
    s/-+$//;
    my $x=$_[0];
    $x =~ s/%@/$_/g;
    return $x;
}
sub run_mencoder{
    use POSIX qw(strftime);
    if(!$v{fps}) { $v{fps}=25;  print "fps=25\n"; }
    my $fname= strftime $out_file, localtime;
    $fname = suburl($fname);
    $cmd="mencoder -frames '$cfg{frames}[0]' -fps '$v{fps}' -ovc copy '$v{href}' -o '$fname'";
    print "cmd=$cmd\n";
    runslv $cmd;
    return $slvp>0;
}
sub rtpcmd{
    return $v{type} =~ m!^video/m|^application/.*elphel-ogm! && $v{href} =~ m|^rtp://([0-9.]+):([0-9]+)/?$|
	&& "ElphelOgm -a$1 -p$2 -s2000000";
}

print "debug=1\n", # list of control variables
      "pause=0\n",
      "framestep=\n",
      "filepos=\n",
      "autostart=\n",
      "play=1\n",
      "save=\n",
      "saveformat=\n",
      "fps=\n",
      "lowres=\n",
      "rotate=0\n",
      "flip=0\n",
      "mirror=0\n",
      "framedelay=0\n",
      "src=\n",
      "href=\n",
      "{this.Play=function(){ this.play=1; }}\n",
      "{this.Stop=function(){ this.pause=1; }}\n",
      "{this.Rewind=function(){ this.filepos=0; this.pause=1; }}\n", 
      "{this.GetURL=function(){ return this.src; }}\n", 
      "{this.SetURL=function(url){ this.src=url; }}\n" unless($ARGV[0] eq '--no-vars');
      
while (<STDIN>){
    s/\n//;
    if( $_ eq '.' ) {
      if($v{href} && $v{autostart} !~ m/^(|0|false)$/i){  ##end of parameters marker
	 $_="run=1";
      }else{next;}
    }
    if($_ !~ /.*=/){
	print "error=1\n";
	next;
    }
    s/'/'\\''/g; #'
    ($x,$y) = split '=', $_, 2;
    if($x eq 'src' || $x eq 'SRC') {
	$v{src}=$y;
	$v{$x='href'}=$y;
    }else{
	$v{$x}=$y;
    }
    if("$_" eq "run=1"){
	$OPTS="";
	$v{baseURI}=~s|/[^/]*$||;
	url2mplayer();
	if($href ne '/dev/fd/3') {
	    print "DESTROY\n"; # close unused stream
	}
	if($v{save}) { #Recording TODO: ask about file overwriting
	    $cmd=rtpcmd();
	    if($cmd) {
		$v{saveformat}="ogm" if($v{saveformat} ne "jpeg");
	    }else{
		$v{saveformat}="avi";
	    }
	    
	    if($v{saveformat} eq "jpeg") {
		$cmd.=" -r -F1" if $cmd;
	    	if(lc $v{save} ne 'auto'){
		    if(!file_dialog(out_file_jpegs)) { print "run=0\n"; last};
		    $out_file=$cfg{out_file_jpegs}[0];
		}elsif( $cfg{not_ask}[0] ){
		    $out_file=$cfg{out_file_jpegs_auto}[0];
		}else{
		    if(!file_dialog(out_file_jpegs_auto, not_ask_jpegs)) { print "run=0\n"; last};
		    $out_file=$cfg{out_file_jpegs_auto}[0];
		}
	    }else{
		if($v{saveformat} eq "avi") {
	    	    $cfg{out_file_once}[0]=~s/\.ogm/\.avi/;
	    	    $cfg{out_file}[0]=~s/\.ogm/\.avi/;		    
		}else{
	    	    $cfg{out_file_once}[0]=~s/\.avi/\.ogm/;
	    	    $cfg{out_file}[0]=~s/\.avi/\.ogm/;
		}
	    	if(lc $v{save} ne 'auto'){
		    if(!file_dialog(out_file_once, frames)) { print "run=0\n"; last};
		    $out_file=$cfg{out_file_once}[0];
		}elsif( $cfg{not_ask}[0] ){
		    $out_file=$cfg{out_file}[0];
		}else{
		    if(!file_dialog(out_file, not_ask, frames)) { print "run=0\n"; last};
		    $out_file=$cfg{out_file}[0];
		}
		$cmd.=" -F '$cfg{frames}[0]'" if $cmd;
	    }
	    if($cmd) {
		$cmd.=" -o".suburl($out_file);
		print "cmd=$cmd\n";
		runslv $cmd;
	    } else {
		$restart=\&run_mencoder;
		run_mencoder();
	    }
	}else{
	    if( $v{xid} ) {
		$OPTS.=" -wid 0x$v{xid}";
                $W = Gtk2::Gdk::Window->foreign_new(hex $v{xid});
		
		if( !$v{width} || $v{width}=~"%" ) {
		    (undef,undef,$v{width},$v{height}) = $W->get_geometry;
		}
                $w=$v{width};
                $gc=Gtk2::Gdk::GC->new($W);
                $gc->set_rgb_fg_color( Gtk2::Gdk::Color->new( 
			(defined $ENV{GENRES_BACKGROUND} && $ENV{GENRES_BACKGROUND} eq "0")? (65535,65535,65535):(0,0,0)
		) );
	    }
	    $p=0;
	    if( $v{rotate} eq 90 ) { $p=5 }
	    elsif( $v{rotate} eq 180 ) { $p=3 }
	    elsif( $v{rotate} eq 270 ) { $p=6 }
	    $p ^= 2 if( $v{flip} !~ m/false|no|0/i );
	    $p ^= 1 if( $v{mirror} !~ m/false|no|0/i );
	    if($p&4) {
		$FILTERS.=",rotate=".($p&3);
	    }else{
		$FILTERS.=",mirror" if( $p&1 );
		$FILTERS.=",flip" if( $p&2 );
	    }
	    print "filters=$FILTERS\n";
	    $OPTS.=" -vf ".substr($FILTERS,1) if( $FILTERS );
	    $OPTS.=" -xy '$v{width}'"	if( $v{width} && $v{width}!~"%" );
	    $OPTS.=" -lavdopts lowres='$v{lowres}'" if( $v{lowres} );
	    $OPTS.=" -fps '$v{fps}'"		if( $v{fps} );
	    $OPTS.=" -fixed-vo -loop ".(0+$v{loop}) if( $href ne "/dev/fd/3" && exists $v{loop} && lc $v{loop} ne 'false' );
	    $loop= 0+$v{loop} if( exists $v{loop} && lc $v{loop} ne 'false' );
	    $OPTS.= localnet()? " -nocache" : " -cache 1000 -cache-min 50";
	    if(( $cmd2=rtpcmd() )) {
	        $cmd2.=" -i -q";
		$cmd2.=" -k $v{frameskip}" if $v{frameskip};
		$cmd2.=" -b $v{framedelay}" if $v{framedelay};
	        $cmd2="|exec $cmd2 2>/dev/null ".fileno(PIPE_OUT)."<&- >/dev/fd/".fileno(PIPE_IN);
		$cmd="mplayer $OPTS -vo $cfg{vo}[0] -zoom -nojoystick -slave -nomouseinput -cookies /dev/fd/".fileno(PIPE_OUT);
	        print "cmd=$cmd\n";
	        print "cmd2=$cmd2\n";
		runslv $cmd;		
		$sl2p=open(SL2W,$cmd2);
	    } else {
		$OPTS.=" -ao $cfg{ao}[0]" if $cfg{ao}[0];
		$cmd="mplayer $OPTS -vo $cfg{vo}[0] -zoom -nojoystick -slave -nomouseinput -cookies '$href'";
	        print "cmd=$cmd\n";
	        runslv $cmd;
	    }
	}
	$ifilt=$$;
	$thrid = threads->new(\&ofilt)->tid;
	ifilt();
	normal_exit();
    }elsif("$_" eq "run=0"){
	print "$_\n";
	last;
    }else{
	print "$x=$y\n";
	if($x eq "href") { print "src=$y\n"; }
    }
}
