#!/usr/bin/perl
# $Id: display.pl,v 1.5 2006/09/22 07:47:02 khlut Exp $
# Bind "display" from ImageMagick with HTML object
#
# Copyright 2006 Elphel, Inc.
#
# This file is part of GenReS.
#
#    GenReS is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    GenReS is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with GenReS; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

use POSIX qw(:sys_wait_h dup2);

###### List of default options

print "debug=1\n", 
      "rotate=0\n",
      "flip=0\n",
      "mirror=0\n",
      "src=\n" unless($ARGV[0] eq '--no-vars');

$v{flip}=$v{mirror}=0;

$^F=4; #to pass pipe with mozilla stream to new process

###### Translate url
      
sub transurl {
    my ($href)=@_;
    if( $href =~ m|^/| ) {
	$href=$&.$href if($v{baseURI} !~ m|^file://| && $v{baseURI} =~ m|^[a-zA-Z0-9]+://[^/]+|);
    }else{
	$href=$v{baseURI}.'/'.$href	if( $href!~m|[a-zA-Z0-9]+:| );
    }
    if($ENV{GENRES_MOZILLA_STREAMS}) {
	$href="/dev/fd/3";
    }else{
	$href=~s|^file://||;
    }
    return $href;
}

###### Recognize options

while (<STDIN>){
    s/\n//;
    if($_ eq '.') { ##end of parameters marker
	next if(!$v{xid} && !$print);
	print "OPEN\n";
	$_="run=1";
    }elsif($_ eq 'PRINTEMBED') {
	pipe PIPE_OUT, PIPE_IN;
	$print='EMBED';
	next;
    }elsif($_ !~ /.*=/){
	print "error=1\n";
	next;
    }
    s/'/'\\''/g; #'
    ($x,$y) = split '=', $_, 2;
    $x='src' if($x eq 'SRC');
    $v{$x}=$y;

    if("$_" eq "run=1"){
	$OPTS="";
	$v{baseURI}=~s|/[^/]*$||;
	$href=transurl($v{src});
	$OPTS.=" -rotate '$v{rotate}'" if( $v{rotate} );
	$OPTS.=" -flip" if( $v{flip} !~ m/false|no|0/i );
	$OPTS.=" -flop" if( $v{mirror} !~ m/false|no|0/i );
	if($print) {
	    if(fork()>0) {
		close PIPE_OUT;
		dup2 fileno(PIPE_IN)=>4;
		$cmd="tee /dev/fd/4 < '$href' | convert $OPTS - eps:-";
	        print "cmd0=$cmd\n";
	        system $cmd;
	        print "%%EOF\n";
		exit 0
	    }else{
		close PIPE_IN;
		dup2 fileno(PIPE_OUT)=>4;
	    }
	    $href="/dev/fd/4";
	}else{
	    $OPTS.=" -verbose";
	}
	if( $v{xid} ) {
	    use Gtk2 -init;
            $W = Gtk2::Gdk::Window->foreign_new(hex $v{xid});
	    my (undef,undef,$width,$height) = $W->get_geometry;
	    $OPTS.=" -resize ${width}x${height}!";
	    $OPTS.=" -window 0x$v{xid}";
	}
	$cmd="display $OPTS '$href'";
	print "cmd=$cmd\nAUTOCLOSE\nrun=1\n";
	open(SLR,"exec $cmd |");
	$_=<SLR>;
	print "msg=$_";
	my ($f,$t,$s,$j,$l,$j)=split ' ';
	print "imgtype=$t\nimgsize=$s\nfilelength=$l\n";
	while(<SLR>) { print "msg=$_" }
	close(SLR);
	waitpid -1,0;
	print "DESTROY\n";
	last;
    }elsif("$_" eq "run=0"){
	print "$_\n";
	last;
    }else{
	print "$x=$y\n";
	if($x eq "href") { print "src=$y\n"; }
    }
}
