// -*- C++ -*-

/* 
 * GChemPaint
 * text-object.cc 
 *
 * Copyright (C) 2002-2003
 *
 * Developed by Jean Bréfort <jean.brefort@ac-dijon.fr>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "text-object.h"
#include <chemistry/xml-utils.h>

extern xmlDocPtr pXmlDoc;
extern GtkTextTagTable* TextTagTable;

static bool on_mark_set(GtkTextBuffer *textbuffer, GtkTextIter *iter, GtkTextMark *mark, gcpTextObject *text)
{
	return text->OnMarkSet(textbuffer, iter, mark);
}

static bool on_insert_text(GtkTextBuffer *textbuffer, GtkTextIter *iter, gchar* newtext, gint length, gcpTextObject *text)
{
	return text->OnInsertText(textbuffer, iter, newtext, length);
}

static bool on_end_user_action(GtkTextBuffer *textbuffer, gcpTextObject *text)
{
	return text->OnEndUserAction(textbuffer);
}

static bool on_changed(GtkTextBuffer *textbuffer, gcpTextObject *text)
{
	return text->OnChanged(textbuffer);
}

gcpTextObject::gcpTextObject(TypeId Type):Object(Type)
{
	m_x = 0.;
	m_y = 0.;
	m_ascent = 0;
	m_length = 5;
	m_height = 15;
	m_InsertOffset = -2;
	m_buf = gtk_text_buffer_new(TextTagTable);
	g_signal_connect(G_OBJECT(m_buf), "mark-set", G_CALLBACK(on_mark_set), this);
	g_signal_connect(G_OBJECT(m_buf), "insert-text", G_CALLBACK(on_insert_text), this);
	g_signal_connect(G_OBJECT(m_buf), "end-user-action", G_CALLBACK(on_end_user_action), this);
	g_signal_connect(G_OBJECT(m_buf), "changed", G_CALLBACK(on_changed), this);
	m_bLoading = false;
}

gcpTextObject::gcpTextObject(double x, double y, TypeId Type):Object(Type)
{
	m_x = x;
	m_y = y;
	m_ascent = 0;
	m_length = 5;
	m_height = 15;
	m_InsertOffset = -2;
	m_buf = gtk_text_buffer_new(TextTagTable);
	g_signal_connect(G_OBJECT(m_buf), "mark-set", G_CALLBACK(on_mark_set), this);
	g_signal_connect(G_OBJECT(m_buf), "insert-text", G_CALLBACK(on_insert_text), this);
	g_signal_connect(G_OBJECT(m_buf), "end-user-action", G_CALLBACK(on_end_user_action), this);
	g_signal_connect(G_OBJECT(m_buf), "changed", G_CALLBACK(on_changed), this);
	m_bLoading = false;
}

gcpTextObject::~gcpTextObject()
{
	if (m_buf) g_object_unref((GObject*)m_buf);
}

xmlNodePtr gcpTextObject::SaveSelected()
{
	xmlNodePtr node = Save(pXmlDoc);
	if (!node) return NULL;
	GtkTextIter start, end;
	gtk_text_buffer_get_selection_bounds(m_buf, &start, &end);
	gchar* buf = g_strdup_printf("%d", gtk_text_iter_get_offset(&end));
	xmlNewProp(node, (xmlChar*)"cursor", (xmlChar*)buf);
	g_free(buf);
	return node;
}

void gcpTextObject::LoadSelected(xmlNodePtr node)
{
	GtkTextIter start, end;
	gtk_text_buffer_get_bounds(m_buf, &start, &end);
	gtk_text_buffer_delete(m_buf, &start, &end);
	Load(node);
	OnChanged(m_buf);
}

bool gcpTextObject::SaveNode(xmlDocPtr xml, xmlNodePtr node)
{
	SaveId(node);
	return WritePosition(xml, node, NULL, m_x, m_y);
}

bool gcpTextObject::Load(xmlNodePtr node)
{
	char* tmp, *endptr;
	xmlNodePtr child;
	tmp = (char*)xmlGetProp(node, (xmlChar*)"id");
	if (tmp) SetId(tmp);
	if (ReadPosition(node, NULL, &m_x, &m_y)) return true;
	tmp = (char*)xmlGetProp(node, (xmlChar*)"x");
	if (!tmp) return false;
	m_x = strtod(tmp, &endptr);
	if (*endptr) return false;
	tmp = (char*)xmlGetProp(node, (xmlChar*)"y");
	if (!tmp) return false;
	m_y = strtod(tmp, &endptr);
	if (*endptr) return false;
	return true;
}

void gcpTextObject::Move(double x, double y, double z)
{
	m_x += x;
	m_y += y;
}
