// -*- C++ -*-

/* 
 * GChemPaint
 * selectiontool.h 
 *
 * Copyright (C) 2001-2003
 *
 * Developed by Jean Bréfort <jean.brefort@ac-dijon.fr>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef GCHEMPAINT_SELECTION_TOOL_H
#define GCHEMPAINT_SELECTION_TOOL_H

#include "tool.h"

class gcpWidgetData;

class gcpSelectionTool: public gcpTool
{
public:
	gcpSelectionTool();
	virtual ~gcpSelectionTool();

	virtual bool OnClicked();
	virtual void OnDrag();
	virtual void OnRelease();
	virtual bool Deactivate();

	void AddSelection(gcpWidgetData* data);

private:
	std::list<gcpWidgetData*> SelectedWidgets;
};

extern gcpSelectionTool SelectionTool;

#endif // GCHEMPAINT_SELECTION_TOOL_H
