// -*- C++ -*-

/* 
 * GChemPaint
 * dialog.h 
 *
 * Copyright (C) 2001-2003
 *
 * Developed by Jean Bréfort <jean.brefort@ac-dijon.fr>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef GCHEMPAINT_DIALOG_H
#define GCHEMPAINT_DIALOG_H
#include <libgnome/libgnome.h>
#include <glade/glade.h>
#include <gtk/gtk.h>
#include <libgnomeui/libgnomeui.h>

enum gcpCheckType
{
	gcpNoCheck,
	gcpMin,
	gcpMax,
	gcpMinMax,
	gcpMinEq,
	gcpMaxEq,
	gcpMinEqMax,
	gcpMinMaxEq,
	gcpMinEqMaxEq
};

class gcpDialog
{
public:
	gcpDialog(const char* filename, const char* windowname, void (*extra_destroy)(gpointer) = NULL, gpointer data = NULL);
	virtual ~gcpDialog();

	virtual void Destroy();
	virtual bool Apply();
	void Help();

protected:
	bool GetNumber(GtkEntry *Entry, double *x, gcpCheckType c = gcpNoCheck, double min = 0, double max = 0);

	void (*m_extra_destroy)(gpointer);
	gpointer m_data;
	GladeXML* xml;
	char m_buf[64];
	gchar* m_windowname;
	GtkWindow *dialog;
};

#endif //GCHEMPAINT_DIALOG_H
