/* Editable GnomeCanvas text item based on GtkTextLayout, borrowed heavily
 * from GtkTextView.
 *
 * Copyright (c) 2000 Red Hat, Inc.
 * Copyright (c) 2001 Joe Shaw
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef GNOME_CANVAS_RICH_TEXT_EXT_H
#define GNOME_CANVAS_RICH_TEXT_EXT_H

#include <libgnomecanvas/gnome-canvas.h>
#include <gtk/gtktextbuffer.h>

G_BEGIN_DECLS

#define GNOME_TYPE_CANVAS_RICH_TEXT_EXT             (gnome_canvas_rich_text_ext_get_type ())
#define GNOME_CANVAS_RICH_TEXT_EXT(obj)             (GTK_CHECK_CAST ((obj), GNOME_TYPE_CANVAS_RICH_TEXT_EXT, GnomeCanvasRichTextExt))
#define GNOME_CANVAS_RICH_TEXT_EXT_CLASS(klass)     (GTK_CHECK_CLASS_CAST ((klass), GNOME_TYPE_CANVAS_RICH_TEXT_EXT, GnomeCanvasRichTextExtClass))
#define GNOME_IS_CANVAS_RICH_TEXT_EXT(obj)          (GTK_CHECK_TYPE ((obj), GNOME_TYPE_CANVAS_RICH_TEXT_EXT))
#define GNOME_IS_CANVAS_RICH_TEXT_EXT_CLASS(klass)  (GTK_CHECK_CLASS_TYPE ((klass), GNOME_TYPE_CANVAS_RICH_TEXT_EXT))
#define GNOME_CANVAS_RICH_TEXT_EXT_GET_CLASS(obj)   (GTK_CHECK_GET_CLASS ((obj), GNOME_TYPE_CANVAS_RICH_TEXT_EXT, GnomeCanvasRichTextExtClass))

typedef struct _GnomeCanvasRichTextExt             GnomeCanvasRichTextExt;
typedef struct _GnomeCanvasRichTextExtPrivate      GnomeCanvasRichTextExtPrivate;
typedef struct _GnomeCanvasRichTextExtClass        GnomeCanvasRichTextExtClass;

struct _GnomeCanvasRichTextExt {
	GnomeCanvasItem item;

    GnomeCanvasRichTextExtPrivate *_priv;
};

struct _GnomeCanvasRichTextExtClass {
	GnomeCanvasItemClass parent_class;

	void (* tag_changed)(GnomeCanvasRichTextExt *text,
			     GtkTextTag *tag);
};

GType gnome_canvas_rich_text_ext_get_type(void) G_GNUC_CONST;

void gnome_canvas_rich_text_ext_cut_clipboard(GnomeCanvasRichTextExt *text);

void gnome_canvas_rich_text_ext_copy_clipboard(GnomeCanvasRichTextExt *text);

void gnome_canvas_rich_text_ext_paste_clipboard(GnomeCanvasRichTextExt *text);

void gnome_canvas_rich_text_ext_set_buffer(GnomeCanvasRichTextExt *text,
				       GtkTextBuffer *buffer);

GtkTextBuffer *gnome_canvas_rich_text_ext_get_buffer(GnomeCanvasRichTextExt *text);
void
gnome_canvas_rich_text_ext_get_iter_location (GnomeCanvasRichTextExt *text,
					  const GtkTextIter *iter,
					  GdkRectangle      *location);
void
gnome_canvas_rich_text_ext_get_iter_at_location (GnomeCanvasRichTextExt *text,
                                    GtkTextIter *iter,
                                    gint         x,
					     gint         y);

PangoLayout* gnome_canvas_rich_text_ext_get_pango_layout (GnomeCanvasRichTextExt *text, gint line);

G_END_DECLS

#endif /* GNOME_CANVAS_RICH_TEXT_EXT_H */
