

#include "games2d.h"

static int bw = 35;
static struct pos fp[4];
static int fpi;
static uint8_t **grid;

/* colors */
static uint32_t cs[] = {
  0x5533bbff,
  0x11ccaaff,
  0xdd3355ff,
  RED,
  GREEN,
  ORANGE,
  WHITE,
};

static pos pieces[][4] = {
  {0,0, 0,1, 0,2, 0,3},
  {0,0, 1,0, 2,0, 3,0},
  {0,0, 0,1, 0,2, 0,3},
  {0,0, 1,0, 2,0, 3,0},

  {0,0, 0,1, 1,1, 2,1},
  {0,0, 1,0, 1,-1, 1,-2},
  {0,0, 1,0, 2,0, 2,1},
  {0,0, 0,1, 0,2, 1,0},

  {0,0, 1,0, 2,0, 2,-1},
  {0,-2, 1,-2, 1,-1, 1,0},
  {0,0, 0,1, 1,0, 2,0},
  {0,0, 1,0, 0,1, 0,2},

  {0,0, 1,0, 0,1, 1,1},
  {0,0, 1,0, 0,1, 1,1},
  {0,0, 1,0, 0,1, 1,1},
  {0,0, 1,0, 0,1, 1,1},

  {0,1, 1,0, 1,1, 2,0},
  {0,1, 0,2, 1,0, 1,1},
  {0,0, 1,0, 1,1, 2,1},
  {0,1, 0,2, 1,0, 1,1},

  {0,0, 1,0, 1,1, 2,0},
  {0,1, 1,0, 1,1, 1,2},
  {0,1, 1,0, 1,1, 2,1},
  {0,0, 0,1, 0,2, 1,1},

  {0,1, 1,0, 1,1, 2,0},
  {0,0, 0,1, 1,1, 1,2},
  {0,1, 1,0, 1,1, 2,0},
  {0,0, 0,1, 1,1, 1,2},
};

static size_t np = nelems (pieces);

static void
drawp (pos p[4], uint32_t c)
{
  for (int i = 0; i < 4; ++i) {
    int x = p[i].x;
    int y = p[i].y;
    if (y + bw < 0)
      continue;
    y = MAX (0, y);
    boxp (p[i], pp(x+bw-1, y+bw-1), c);
  }
}
static void
drawbp (pos p[4], uint32_t c)
{
  for (int i = 0; i < 4; ++i) {
    int x = p[i].x;
    int y = p[i].y;
    if (y + bw <= 0)
      continue;
    y = MAX (0, y);
    boxp (pp(x,y), pp(x+bw-1, p[i].y+bw-1), c);
    borderp (pp(x,y), pp(x+bw-1, p[i].y+bw-1), BLACK);
  }
}
static void
clearfp (void) { drawp (fp, bgcolor); }
static void
drawfp (void)
{ 
  drawbp (fp, cs[fpi/4]);
} 

static int
newp (struct pos p[4])
{
  uint r = rand()%np;
  int mx = 0, my = 0;
  for (int i = 0; i < 4; ++i) {
    mx = MAX (pieces[r][i].x, mx);
    my = MAX (pieces[r][i].y, my);
  }

  int ox = rand()%(scrn.w - mx*bw) / bw;
  for (int i = 0; i < 4; ++i) {
    p[i].y = pieces[r][i].y*bw - my*bw;
    p[i].x = pieces[r][i].x*bw + ox*bw;
  }

  return r;
}

static int
collides (pos p[4])
{
  for (int i = 0; i < 4; ++i) {
    pos z = p[i];
    if (z.x < 0 || z.x >= scrn.w ||
	z.y + bw >= scrn.h)
      {
	return 1;
      }

    if (z.y + bw < 0)
      continue;
    if (grid[(z.y+bw)/bw][z.x/bw] != 0)
      return 1;

    if (z.y < 0)
      continue;
    if (grid[(z.y)/bw][z.x/bw] != 0)
      return 1;
  }

  return 0;
}

static void
incy (pos p[4])
{ for (int i = 0; i < 4; ++i)
    p[i].y += 5; }

/* h= 0: normal, 1: soft, 2: hard */
static int
fallit (int h)
{
  if (h == 0)
    incy (fp);
  else if (h == 1) {
    incy (fp);
    if (! collides (fp))
      incy (fp);
  }
  else
    while (! collides (fp))
      incy (fp);

  if (collides (fp)) {

    for (int i = 0; i < 4; ++i)
      if (fp[i].y < 0)
	return 1;

    drawfp ();

    for (int i = 0; i < 4; ++i) {
      grid[fp[i].y/bw][fp[i].x/bw] = fpi/4 + 1;
      int my = -1;
      for (int y = 0; y < scrn.h; y += bw) {
	int x;
	for (x = 0; x < scrn.w; x += bw)
	  if (grid[y/bw][x/bw] == 0)
	    break;
	if (x == scrn.w) {
	  for (int y1 = y; y1 > bw; y1 -= bw)
	    memmove (grid[y1/bw], grid[y1/bw-1], scrn.w/bw + 1);

	  memset (grid[0], 0, scrn.w/bw + 1);
	  my = y;
	}
      }
      if (my != -1) {
	boxp (pp(0, 0), pp(scrn.w, my+bw), bgcolor);
	for (int y = bw; y <= my; y += bw)
	  for (int x = 0; x < scrn.w; x += bw)
	    if (grid[y/bw][x/bw]) {
	      boxp (pp(x, y), pp(x+bw-1, y+bw-1), cs[grid[y/bw][x/bw]-1]);
	      borderp (pp(x,y), pp(x+bw-1, y+bw-1), BLACK);
	    }
      }
    }

    fpi = newp (fp);
  }

  return 0;
}
static void
slide (struct pos p[4], int hm)
{
  for (int i = 0; i < 4; ++i)
    p[i].x += hm*bw;
  if (collides (p))
    slide (p, -hm);
}
static void
rot (int d)
{
  int ofpi = fpi;
  int m = fpi % 4 + d;
  m = m < 0 ? 3 : m > 3 ? 0 : m;
  fpi = fpi-(fpi%4) + m;
  for (int i = 0; i < 4; ++i) {
    fp[i].x -= pieces[ofpi][i].x*bw;
    fp[i].y -= pieces[ofpi][i].y*bw;
    fp[i].x += pieces[fpi][i].x*bw;
    fp[i].y += pieces[fpi][i].y*bw;
  }
  if (collides (fp))
    rot (-d);
}
int
main (int argc, char **argv)
{
  fps = 20;

  scrn.w = 385;
  scrn.h = 595;

  blkw = 35;
  // blkp = 4;

  g2dinit (&argc, &argv, 0);

  boxp (pp(0,0), pp(scrn.w,scrn.h), bgcolor);

  hplayers = 1;

  grid = g_slice_alloc (scrn.h/bw * sizeof (uint8_t *));
  void *p = g_slice_alloc0 (scrn.w/bw * scrn.h/bw);
  for (int i = 0; i < scrn.h/bw; ++i)
    grid[i] = p + scrn.w/bw*i;

  fpi = newp (fp);

  while (mainloop (1000 / fps)) {
    enum keys k0;

    getinput ();

    k0 = getkey ((enum keys [])
                 {KRIGHT, KDOWN, KLEFT, KUP, KSPACE, KNONE}, 0);
    clearfp ();

    if (k0 == KUP)
      rot (1);
    if (k0 == KRIGHT)
      slide (fp, 1);
    else if (k0 == KLEFT)
      slide (fp, -1);
    else {
      int h = 0;
      if (k0 == KDOWN)
	h = 1;
      else if (k0 == KSPACE)
	h = 2;

      if (fallit (h))
	error (1, 0, "game over");
    }
    
    drawfp ();

    // updater ((rec){0, 0, 0, 0});
  }

  return 0;
}
