/* Copyright (C) 2013 by Alexandru Cojocaru */

/* This file is part of games2d.
 
   games2d is free software: you can redistribute
   it and/or modify it under the terms of the
   GNU General Public License as published by the
   Free Software Foundation, either version 3 of the License,
   or (at your option) any later version.

   games2d is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty
   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See
   the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program. If not, see http://www.gnu.org/licenses/. */

/* ideas:
   two players
   walls
   minimize
*/

#include "games2d.h"

static struct pos *snake;
static size_t asnake = 10;
static size_t csnake;
static uint headi;
static struct pos *worms;
static size_t aworms = 5;
static size_t cworms;

static int
collides (struct pos pos)
{
  for (uint i = 0; i < csnake; ++i)
    if (snake[i].x == pos.x &&
	snake[i].y == pos.y)
      return 1;
  return 0;
}
int
main (int argc, char *argv[])
{
  USED(argc);
  USED(argv);

  scrn.w = 500;
  scrn.h = 500;

  // fps = 11;

  blkp = 5;

  g2dinit (&argc, &argv, 0);

  snake = g_malloc (asnake * sizeof (struct pos));
  csnake = asnake;
  for (uint i = 0; i < csnake; ++i) {
    snake[i] = pp((csnake+4) * blkw - i*blkw, scrn.h/2 - blkw/2);
    snake[i].x -= snake[i].x % blkw;
    snake[i].y -= snake[i].y % blkw;
  }

  worms = g_malloc (aworms * sizeof (struct pos));
  for (uint i = 0; i < aworms; ++i)
    worms[i].x = -1;

  enum keys k = KRIGHT;
  while (mainloop (1000 / fps)) {
    struct pos d = pp(0,0);

    getinput ();
    enum keys k0 = getkey ((enum keys [])
                           {KRIGHT, KDOWN, KLEFT, KUP, KNONE}, 0);
    if (k0 != KNONE)
      k = k0;
    
    /** snake **/

    switch (k) {
    case KRIGHT: case Kd:
      d.x = blkw; break;
    case KDOWN: case Ks:
      d.y = blkw; break;
    case KLEFT: case Ka:
      d.x = -blkw; break;
    case KUP: case Kw:
      d.y = -blkw; break;
    case KNONE:
      break;
    default:
      abort ();
    }

    uint oldi = headi;
    headi = headi ? headi - 1 : csnake - 1;

    struct pos olds = snake[headi];

    snake[headi] = pp(snake[oldi].x + d.x, snake[oldi].y + d.y);

    if (snake[headi].x + blkw > scrn.w)
      snake[headi].x = 0;
    else if (snake[headi].x < 0)
      snake[headi].x = scrn.w - blkw;

    if (snake[headi].y + blkw > scrn.h)
      snake[headi].y = 0;
    else if (snake[headi].y < 0)
      snake[headi].y = scrn.h - blkw;

    /** worms **/

    {
      uint i = 0;
      while (cworms < aworms) {
	while (worms[i].x >= 0)
	  ++i;
      new_worm:;
	worms[i] = pp(rand() % (scrn.w - (scrn.w%blkw)), rand() % (scrn.h - (scrn.h%blkw)));

	worms[i].x -= worms[i].x % blkw;
	worms[i].y -= worms[i].y % blkw;

	if (collides (worms[i]))
	  goto new_worm;
	++cworms;
      }
    }

    /** collision detection **/

    struct pos oldw = pp(-1,-1);
    for (uint i = 0; i < aworms; ++i) {
      if (snake[headi].x == worms[i].x &&
	  snake[headi].y == worms[i].y) {
	oldw = worms[i];
	worms[i].x = -1;
	--cworms;
	++csnake;
	if (csnake > asnake) {
	  snake = g_realloc (snake, asnake*2);
          asnake *= 2;
        }

	if (headi == 0) {
	  snake[csnake - 1] = snake[1];
	  continue;
	}
	/* swap */
	snake[csnake - 1] = snake[0];
	memmove (snake, snake + 1, (headi - 1) * sizeof (struct pos));
	snake[headi - 1] = snake[headi - 1];
	break;
      }
    }

    {
      uint i = (headi + 1) % csnake;
      for (uint j = 0; j < csnake - 1; ++j) {
	if (snake[i].x == snake[headi].x &&
	    snake[i].y == snake[headi].y) {
	  uint pi = i ? i - 1 : csnake - 1;
	  uint pheadi = (headi + 1) % csnake;
	  if ((snake[pi].x != snake[pheadi].x) &&
	      (snake[pi].y != snake[pheadi].y))
	    error (1, 0, "died: self poisoned");
	}
	i = (i + 1) % csnake;
      }
    }	
	
    /** draw **/

    boxp (olds, pp(olds.x + blkw, olds.y + blkw), bgcolor);
    if (oldw.x != -1)
      boxp (oldw, pp(oldw.x + blkw, oldw.y + blkw), bgcolor);

    uint i = headi;
    for (uint j = 0; j < csnake; ++j) {
      boxp (snake[i], pp(snake[i].x + blkw, snake[i].y + blkw),
	   0xddaa33ff);
      i = ((i + 1) % csnake);
    }
    
    for (uint i = 0; i < aworms; ++i) {
      if (worms[i].x < 0)
	continue;
      boxp (worms[i], pp(worms[i].x + blkw, worms[i].y + blkw),
	   0x990099);
    }

    updater ((rec) {0, 0, 0, 0});
  }

  return 0;
}
