/* Copyright (C) 2013 by Alexandru Cojocaru */

/* This file is part of games2d.
 
   games2d is free software: you can redistribute
   it and/or modify it under the terms of the
   GNU General Public License as published by the
   Free Software Foundation, either version 3 of the License,
   or (at your option) any later version.

   games2d is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty
   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See
   the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program. If not, see http://www.gnu.org/licenses/. */

#include "games2d.h"

static obj pad[2];
static int lastdir[2];

static obj b = {.dy = 2, .c = (GREEN & (~0xff)) | 0x77};
static int off = 2;

static uint score[2];

static void
reposition (void)
{
  pad[0].r.w = pad[1].r.w = 10;
  pad[0].r.h = pad[1].r.h = blkw*10;
  pad[0].dx = pad[1].dx = blkw;
  pad[0].c = pad[1].c = WHITE;

  pad[0].r.x = off;
  pad[0].r.y = rnd (0, scrn.h-pad[0].r.h);
  pad[1].r.x = scrn.w - pad[1].r.w - off;
  pad[1].r.y = rnd (0, scrn.h-pad[0].r.h);

  b.r.w = b.r.h = blkw;
  b.dx = 10;
  b.dy = rnd (0, blkw/2);
  b.r = (rec){scrn.w/2 - b.r.w/2, scrn.h/2 - b.r.w/2, blkw,blkw};
}
static void
ball (void)
{
  b.r.x += b.dx;
  b.r.y += b.dy;
}
static void
player (uint p, enum keys key)
{
  boxr (pad[p].r, bgcolor);
  switch (key) {
  case KUP: case Kw:
    sub (pad[p].r.y, pad[p].dx, 0);
    lastdir[p] = -1;
    break;
  case KDOWN: case Ks:
    add (pad[p].r.y, pad[p].dx, scrn.h - 1 - pad[p].r.h - 1);
    lastdir[p] = 1;
    break;
  case KNONE:
    lastdir[p] = 0;
    break;
  default:
    abort ();
  }
  boxr (pad[p].r, pad[p].c);
}
static int
collision (void)
{
  int collided = 0;

  if ((b.r.x < pad[0].r.x + pad[0].r.w) &&
      (b.r.y + b.r.h > pad[0].r.y) &&
      (b.r.y < pad[0].r.y + pad[0].r.h))
    { 
      float v = fabsf (((float)pad[0].r.h/2 - (b.r.y - pad[0].r.y))) /
        (float)pad[0].r.h/2;
      b.dy += v * sign (b.dy);
      b.r.x = pad[0].r.x + pad[0].r.w + off;
      collided = 1;
    }
  else if ((b.r.x + b.r.w > pad[1].r.x) &&
	   (b.r.y + b.r.w > pad[1].r.y) &&
           (b.r.y < pad[1].r.y + pad[1].r.h))
    {
      float v = fabsf (((float)pad[0].r.h/2 - (b.r.y - pad[1].r.y))) /
        (float)pad[0].r.h/2;
      v *= 10;
      b.dy += v * sign (b.dy);
      b.r.x = pad[1].r.x - b.r.w - off;
      collided = 1;
    }
  else if (b.r.x + b.r.w < 0)
    return 1;
  else if (b.r.x > scrn.w)
    return 0;
  else if (b.r.y < 0) {
    b.r.y = 1;
    b.dy *= -1;
  }
  else if (b.r.y + b.r.w > scrn.h) {
    b.r.y = scrn.h - b.r.w - 1;
    b.dy *= -1;
  }

  if (collided) {
    b.dx += 0.2 * sign (b.dx);
    b.dx *= -1;

    int i = b.r.x > scrn.w/2;
    if (lastdir[i])
      b.dy = lastdir[i] * abs (b.dy);
  }

  return -1;
}
int
main (int argc, char *argv[])
{
  scrn.w = 500;
  scrn.h = 500;

  fps = 60;
  blkp = 2;
  
  g2dinit (&argc, &argv, 0);

  reposition ();

  if (rnd (0, 2))
    b.dx *= -1;
  if (rnd (0, 2))
    b.dy *= -1;

  boxr (pad[0].r, pad[0].c);
  boxr (pad[1].r, pad[1].c);
  boxr (b.r, b.c);

  while (mainloop (1000 / fps)) {
    enum keys k0, k1;

    k0 = getkey ((enum keys [])
                 {Kw, Ks, KNONE}, 0);
    player (0, k0);
    
    k1 = getkey ((enum keys [])
                 {KUP, KDOWN, KNONE}, 0);
    player (1, k1);

    boxr (b.r, bgcolor);
    ball ();

    int i;
    if ((i = collision ()) >= 0) {
      printf ("player %d scored\n", i);
      ++score[i];
      boxr (pad[0].r, bgcolor);
      boxr (pad[1].r, bgcolor);
      reposition ();
    }
    
    boxr (b.r, b.c);
  }

  return 0;
}
