/* Copyright (C) 2013 by Alexandru Cojocaru */

/* This file is part of games2d.
 
   games2d is free software: you can redistribute
   it and/or modify it under the terms of the
   GNU General Public License as published by the
   Free Software Foundation, either version 3 of the License,
   or (at your option) any later version.

   games2d is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty
   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See
   the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program. If not, see http://www.gnu.org/licenses/. */

#include "games2d.h"

GSList *pressed;

enum keys
getkey (enum keys *keys, int rm)
{
  enum keys *p = keys;
  GSList *e = NULL;
  while (*p != KNONE) {
    e = g_slist_find (pressed, INT2PTR(*p));
    if (e)
      break;
    ++p;
  }
  if (e && rm)
    pressed = g_slist_remove (pressed, INT2PTR(*p));
  return *p;
}
static int
handle_common_keys (enum keys k)
{
  int h = 0;
  switch (k) {
  case Kq:
    exit (0);
    break;
  default:
    break;
  }
  return h;
}
void
keypresscb (enum keys k)
{
  if (! handle_common_keys (k))
    if (! g_slist_find (pressed, INT2PTR (k)))
      pressed = g_slist_prepend (pressed, INT2PTR (k));
}
void
keyreleasecb (enum keys k)
{
   pressed = g_slist_remove (pressed, INT2PTR (k));
}
