/* Copyright (C) 2013 by Alexandru Cojocaru */

/* This file is part of games2d.
 
   games2d is free software: you can redistribute
   it and/or modify it under the terms of the
   GNU General Public License as published by the
   Free Software Foundation, either version 3 of the License,
   or (at your option) any later version.

   games2d is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty
   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See
   the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program. If not, see http://www.gnu.org/licenses/. */

#include "games2d.h"
#include "videoinit.h"
#include "gtk.h"

static int
_drawcb (GtkWidget *w, cairo_t *cr, void *data)
{
  USED (cr);
  USED (data);
  USED (w);
  static int c = 0;
  /* KLUDGE: `getinput' is called inside `gtk_init'
     so a `draw' signal is generated, but since not everything
     is set up we could get a SEGFAULT, so we avoid the
     first draw signal. */
  if (c) {
    if (drawcb)
      (*drawcb) ();
  } else
    c = 1;
  return 0;
}
         

void
init (int *argc, char ***argv, int g2dflags)
{
  USED (g2dflags);
  
  gtk_init (argc, argv);
  screen = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  //gtk_window_set_default_size (GTK_WINDOW (screen), scrn.w, scrn.h);
  
  gtk_window_set_resizable (GTK_WINDOW (screen), 0);
  gtk_window_set_position (GTK_WINDOW (screen), GTK_WIN_POS_CENTER);
  
  GdkGeometry hints;
  hints.base_width = scrn.w;
  hints.base_height = scrn.h;
  hints.width_inc = blkw;
  hints.height_inc = blkw;
  hints.min_width = hints.max_width = scrn.w;
  hints.min_height = hints.max_height = scrn.h;

  gtk_window_set_geometry_hints (GTK_WINDOW (screen), NULL,
                                 &hints,
                                 GDK_HINT_MIN_SIZE |
                                 GDK_HINT_MAX_SIZE);
  
  {
    int w,h;
    gtk_window_get_size (GTK_WINDOW (screen), &w, &h);
    if (w != scrn.w)
      printf ("scrn.w: %d, w: %d\n", scrn.w, w);
    if (h != scrn.h)
      printf ("scrn.h: %d, h: %d\n", scrn.h, h);
    /* assert (scrn.w == w); */
    /* assert (scrn.h == h);  */ 
  }
  
  g_signal_connect_swapped (screen, "destroy", G_CALLBACK (exit), 0);

  drawa = gtk_drawing_area_new ();

  gtk_container_add (GTK_CONTAINER (screen), drawa);
  
  gtk_widget_show_all (screen);

  g_signal_connect (screen, "key-press-event",
                    G_CALLBACK (gtk_keypresscb), NULL);
  g_signal_connect (screen, "key-release-event",
                    G_CALLBACK (gtk_releasecb), NULL);

  g_signal_connect (drawa, "draw",
                    G_CALLBACK (_drawcb), NULL);
  
  getinput ();
}
