/* Copyright (C) 2013 by Alexandru Cojocaru */

/* This file is part of games2d.
 
   games2d is free software: you can redistribute
   it and/or modify it under the terms of the
   GNU General Public License as published by the
   Free Software Foundation, either version 3 of the License,
   or (at your option) any later version.

   games2d is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty
   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See
   the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program. If not, see http://www.gnu.org/licenses/. */

#pragma once

enum {
  BLACK = 0x000000ff,
  RED =   0xff0000ff,
  GREEN = 0x00ff00ff,
  BLUE =  0x0000ffff,
  WHITE = 0xffffffff,

  ORANGE = 0xdd9300ff,
};

typedef struct pos pos;
struct pos {
  union {
    int16_t x,w;
    float dx;
  };
  union {
    int16_t y,h;
    float dy;
  };
};
AUSED static pos
pp (int16_t xw, int16_t yh)
{
  return (pos){{xw},{yh}};
}

typedef struct rec rec;
struct rec {
  int16_t x,y,w,h;
};

typedef void img;

typedef struct obj obj;
struct obj {
  rec r;
  float dx,dy, ddx,ddy;
  union {
    uint32_t c;
    img *img;
  };
};


void boxp (pos s, pos e, uint32_t c);
void boxr (rec r, uint32_t c);
void boxo (obj o);
void borderp (pos s, pos e, uint32_t c);
void borderr (rec r, uint32_t c);
void bezier (int16_t *xv, int16_t *yv, uint n, uint32_t c);
void updater (struct rec rec);
img * loadimg (char *s, int w, int h);
void freeimg (img *i);
void blit (img *src, rec srcr, img *dst, rec dstr);
void blito (obj o);
