/* Copyright (C) 2013 by Alexandru Cojocaru */

/* This file is part of games2d.
 
   games2d is free software: you can redistribute
   it and/or modify it under the terms of the
   GNU General Public License as published by the
   Free Software Foundation, either version 3 of the License,
   or (at your option) any later version.

   games2d is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty
   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See
   the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program. If not, see http://www.gnu.org/licenses/. */

int __sub (int a, int b, int min, int max);
int __add (int a, int b, int min, int max);
// #define sub(a, b, min, max) (a) = __sub (a, b, min, max)
// #define add(a, b, min, max) (a) = __add (a, b, min, max)
#define sub(a, b, min)                                  \
  (a) = ({__typeof__(a) _r = a-b; _r<min ? 0 : _r; })
#define add(a, b, max)                                  \
  (a) = ({__typeof__(a) _r = a+b; _r>max ? max : _r; })

#define addr(a, b)                              \
  a.x += b.x; a.y += b.y
