#!/usr/bin/env bash
# Written in 2013 by Alexandru Cojocaru <xojoc@gmx.com>
# This file is part of games2d.
# As an exception I am releasing this file in
# the Public domain: use this file as you wish. NO WARRANTY.

echo "# automaticaly generated from $0, DON'T EDIT" > build-aux/progs.mk
gfxlib=$1

echo "=**==*==**= building with $gfxlib ==="

gfxf="src/${gfxlib}_draw.c src/${gfxlib}_input.c src/${gfxlib}_init.c"

cf="src/arith.c src/collision.c src/dbg.c src/games2d.c src/input.c $gfxf"
gen="src/keyslst.h"
# pacman 
progs=(breakout pong snake space_invaders tetris tron)
echo "bin_PROGRAMS := ${progs[@]/#/g2d}" >> build-aux/progs.mk
echo >> build-aux/progs.mk
for p in ${progs[@]}; do
    echo "g2d${p}_SOURCES := src/${p}.c $cf" >> build-aux/progs.mk
    echo "nodist_g2d${p}_SOURCES := $gen" >> build-aux/progs.mk
    echo "src/${p}.\$(OBJEXT): $gen" >> build-aux/progs.mk
    echo >> build-aux/progs.mk
done

