#!/usr/bin/env bash
# Written in 2013 by Alexandru Cojocaru <xojoc@gmx.com>
# This file is part of games2d.
# As an exception I am releasing this file in
# the Public domain: use this file as you wish. NO WARRANTY.

### keep in sync with gen-sdlkeyslst.sh

cat build-aux/keyslst | awk 'BEGIN {print "\
#pragma once\n\
#include <gdk/gdkkeysyms.h>\n\
enum keys {"}\
                                                        \
$0 == "# special", $0 == "# end special" {              \
    if ($0 == "KNONE")                                  \
        print "\t" "KNONE = GDK_KEY_VoidSymbol" ",";    \
}                                                       \
                                                        \
                                                        \
$0 == "# non textual", $0 == "# end non textual" {                      \
    if ($0 != "# non textual" &&                                        \
        $0 != "# end non textual")                                      \
    {                                                                   \
        print "\t" $0 " = GDK_KEY_" toupper (substr ($0, 2, 1)) tolower (substr ($0, 3)) "," ; \
    }                                                                   \
}                                                                       \
                                                                        \
$0 == "# textual", $0 == "# end textual" {                              \
    if ($0 != "# textual" &&                                            \
        $0 != "# end textual")                                          \
    {                                                                   \
        s = substr ($0, 2);                                             \
        if (length ($0) > 2)                                            \
            s = tolower (s);                                            \
        print "\t" $0 " = GDK_KEY_" s "," ;                             \
    }                                                                   \
}                                                                       \
                                                                        \
END {print "};"}' > src/keyslst.h
