// -*- C++ -*-
//
// Copyright (C) 1998, 1999, 2000, 2002  Los Alamos National Laboratory,
// Copyright (C) 1998, 1999, 2000, 2002  CodeSourcery, LLC
//
// This file is part of FreePOOMA.
//
// FreePOOMA is free software; you can redistribute it and/or modify it
// under the terms of the Expat license.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Expat
// license for more details.
//
// You should have received a copy of the Expat license along with
// FreePOOMA; see the file LICENSE.
//

//-----------------------------------------------------------------------------
// Class:
// TransformPatch
//-----------------------------------------------------------------------------

#ifndef POOMA_TRANSFORM_TRANSFORM_PATCH_H
#define POOMA_TRANSFORM_TRANSFORM_PATCH_H

//////////////////////////////////////////////////////////////////////

/** @file
 * @ingroup Utilities
 * @brief
 * Undocumented.
 */

//-----------------------------------------------------------------------------
// Overview: 
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Typedefs:
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Includes:
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Forward Declarations:
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
//
// Full Description:
//
//-----------------------------------------------------------------------------

template<int Dim, class Function>
class TransformPatch
{
public:
  typedef typename Function::Element_t Element_t;
  CTAssert(Function::sliceDimensions == 2);
  CTAssert(Function::inPlace == true);
  CTAssert(Dim > 1);

  TransformPatch(int transformDim, const Function &func)
    : transformDim_m(transformDim), function_m(func)
  { }

  void apply(const Array<Dim, Element_t, BrickView<Dim> >& a)
  {
    Loc<Dim> loc;
    int ends[Dim];
    int i;

    for (i = 0; i < Dim; ++i)
    {
      loc[i]  = Loc<1>(0);
      ends[i] = a.domain()[i].size();
    }

    int dim2    = (transformDim_m == 0) ? 1 : 0;
    int length  = ends[transformDim_m];
    int lot     = ends[dim2];
    int istride = a.engine().strides()[transformDim_m];
    int idist   = a.engine().strides()[dim2];

    function_m.initialize(Loc<2>(length, lot), Loc<2>(istride, idist));

    bool more = true;

    while(more)
    {
      function_m.apply(&a(loc));

      more = false;
      for (i = 0; i < Dim; ++i)
      {
	if ((i != transformDim_m) && (i != dim2))
	{
	  loc[i] += 1;
	  if (loc[i].first() != ends[i])
	  {
	    i = Dim;
	    more = true;
	  }
	  else
	  {
	    loc[i] = Loc<1>(0);
	  }
	}
      }
    }

    function_m.finalize();
  }

private:
  int transformDim_m;
  Function function_m;
};


//////////////////////////////////////////////////////////////////////

#endif     // POOMA_TRANSFORM_TRANSFORM_PATCH_H

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: TransformPatch.h,v $   $Author: richard $
// $Revision: 1.5 $   $Date: 2004/11/01 18:17:13 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
