// -*- C++ -*-
//
// Copyright (C) 1998, 1999, 2000, 2002  Los Alamos National Laboratory,
// Copyright (C) 1998, 1999, 2000, 2002  CodeSourcery, LLC
//
// This file is part of FreePOOMA.
//
// FreePOOMA is free software; you can redistribute it and/or modify it
// under the terms of the Expat license.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Expat
// license for more details.
//
// You should have received a copy of the Expat license along with
// FreePOOMA; see the file LICENSE.
//

#ifndef POOMA_POOMA_PAWS_H
#define POOMA_POOMA_PAWS_H

/** @file
 * @ingroup Pooma
 * @brief
 * A one-stop-shopping header file that sets up everything one needs to use
 * Paws for various data types.
 */

// Include files for the Paws Connection.

#include "Connect/Paws/PawsConnection.h"

// Include files for the Paws Connectors.

#include "Connect/Paws/PawsConnector.h"
#include "Connect/Paws/PawsConnector.String.h"
#include "Connect/Paws/PawsConnector.Array.h"
#include "Connect/Paws/PawsConnector.Field.h"
#include "Connect/Paws/PawsConnector.DynamicArray.h"

#endif

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: Paws.h,v $   $Author: richard $
// $Revision: 1.8 $   $Date: 2004/11/01 18:17:04 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
