// -*- C++ -*-
//
// Copyright (C) 1998, 1999, 2000, 2002  Los Alamos National Laboratory,
// Copyright (C) 1998, 1999, 2000, 2002  CodeSourcery, LLC
//
// This file is part of FreePOOMA.
//
// FreePOOMA is free software; you can redistribute it and/or modify it
// under the terms of the Expat license.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Expat
// license for more details.
//
// You should have received a copy of the Expat license along with
// FreePOOMA; see the file LICENSE.
//

#ifndef POOMA_POOMA_LUX_H
#define POOMA_POOMA_LUX_H

/** @file
 * @ingroup Pooma
 * @brief
 * A one-stop-shopping header file that sets up everything one needs to use
 * the Lux package for run-time visualization.
 */

// Include files for the Lux Connection.

#include "Connect/Lux/LuxConnection.h"

// Include files for the Lux structured-grid Connectors.

#include "Connect/Lux/LuxConnector.Array.h"
#include "Connect/Lux/LuxConnector.Field.h"
#include "Connect/Lux/LuxConnector.Particles.h"

#endif

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: Lux.h,v $   $Author: richi $
// $Revision: 1.5 $   $Date: 2004/11/02 13:08:02 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
