// -*- C++ -*-
//
// Copyright (C) 1998, 1999, 2000, 2002  Los Alamos National Laboratory,
// Copyright (C) 1998, 1999, 2000, 2002  CodeSourcery, LLC
//
// This file is part of FreePOOMA.
//
// FreePOOMA is free software; you can redistribute it and/or modify it
// under the terms of the Expat license.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Expat
// license for more details.
//
// You should have received a copy of the Expat license along with
// FreePOOMA; see the file LICENSE.
//

//-----------------------------------------------------------------------------
// Class:
// TypeInfo<> specializations for Coordinate things.
//-----------------------------------------------------------------------------

#ifndef POOMA_COORDINATESYSTEMS_COORDINATETYPEINFO_H
#define POOMA_COORDINATESYSTEMS_COORDINATETYPEINFO_H

//////////////////////////////////////////////////////////////////////

//-----------------------------------------------------------------------------
// Overview: 
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Typedefs:
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Includes:
//-----------------------------------------------------------------------------

#include "Utilities/TypeInfo.h"

//-----------------------------------------------------------------------------
// Forward Declarations:
//-----------------------------------------------------------------------------

template<int Dim> class Cartesian;

//-----------------------------------------------------------------------------
//
// Full Description:
//
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Compile-time TypeInfo for CoordinateSystems.
//-----------------------------------------------------------------------------

template<int Dim>
struct TypeInfo<Cartesian<Dim> >
{
  static inline std::string name()
  {
    return "Cartesian<" + TypeInfoInt<Dim>::name() + ">";
  }
};

//////////////////////////////////////////////////////////////////////

#endif     // POOMA_COORDINATESYSTEMS_COORDINATETYPEINFO_H

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: CoordinateTypeInfo.h,v $   $Author: richard $
// $Revision: 1.3 $   $Date: 2004/11/01 18:16:25 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
