// -*- C++ -*-
//
// Copyright (C) 1998, 1999, 2000, 2002  Los Alamos National Laboratory,
// Copyright (C) 1998, 1999, 2000, 2002  CodeSourcery, LLC
//
// This file is part of FreePOOMA.
//
// FreePOOMA is free software; you can redistribute it and/or modify it
// under the terms of the Expat license.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Expat
// license for more details.
//
// You should have received a copy of the Expat license along with
// FreePOOMA; see the file LICENSE.
//
//-----------------------------------------------------------------------------
// SimpleJacobi.cpp demonstrates the two most basic features of POOMA II:
// multi-dimensional arrays, and interval indexing.  The program is used in
// Tutorial 1.
//-----------------------------------------------------------------------------

#include "Pooma/Arrays.h"

#include <iostream>

// The size of each side of the domain.
const int N = 20;

int
main(
    int                 argc,           // argument count
    char *              argv[]          // argument list
){
    // Initialize Pooma.
    Pooma::initialize(argc, argv);

    // The array we'll be solving for
    Array<2> V(N, N);
    V = 0.0;

    // The right hand side of the equation (spike in the center)
    Array<2> b(N, N);
    b = 0.0;
    
    // Must block since we're doing some scalar code (see Tutorial 4).
    Pooma::blockAndEvaluate();
    b(N/2, N/2) = -1.0;

    // Specify the interior of the domain
    Interval<1> I(1, N-2), J(1, N-2);

    // Iterate 200 times
    for (int iteration=0; iteration<200; ++iteration)
    {
        V(I,J) = 0.25*(V(I+1,J) + V(I-1,J) + V(I,J+1) + V(I,J-1) - b(I,J));
    }

    // Print out the result
    std::cout << V << std::endl;

    // Clean up Pooma and report success.
    Pooma::finalize();
    return 0;
}

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: SimpleJacobi.cpp,v $   $Author: richard $
// $Revision: 1.12 $   $Date: 2004/11/01 18:16:04 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
