// -*- C++ -*-
//
// Copyright (C) 1998, 1999, 2000, 2002  Los Alamos National Laboratory,
// Copyright (C) 1998, 1999, 2000, 2002  CodeSourcery, LLC
//
// This file is part of FreePOOMA.
//
// FreePOOMA is free software; you can redistribute it and/or modify it
// under the terms of the Expat license.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Expat
// license for more details.
//
// You should have received a copy of the Expat license along with
// FreePOOMA; see the file LICENSE.
//
//-----------------------------------------------------------------------------
// Sequential.cpp is used in Tutorial 1.  It uses POOMA's array classes simply
// to contain data, and makes no use of POOMA's data-parallel features.
//-----------------------------------------------------------------------------

#include "Pooma/Arrays.h"

#include <iostream>

// The size of each side of the domain.
const int N = 20;

int
main(
    int                 argc,           // argument count
    char *              argv[]          // argument list
){
    // Initialize Pooma.
    Pooma::initialize(argc, argv);

    // The array we'll be solving for
    Array<2> V(N, N);

    // The right hand side of the equation (spike in the center)
    Array<2> b(N, N);

    // Block since we're doing scalar code (see Tutorial 4).
    Pooma::blockAndEvaluate();
    
    // Initialize.
    int i, j;
    for (i=0; i<N; ++i){
        for (j=0; j<N; ++j){
            V(i, j) = 0.0;
            b(i, j) = 0.0;
        }
    }
    b(N/2, N/2) = -1.0;

    // Iterate 200 times
    Array<2> temp(N, N);
    for (int iteration=0; iteration<200; ++iteration)
    {
        // Use V to fill temp
        for (i=1; i<N-1; ++i){
            for (j=1; j<N-1; ++j){
                temp(i, j) = 0.25 * ( V(i+1,j) + V(i-1,j) +
                                      V(i,j+1) + V(i,j-1) - b(i,j) );
            }
        }
        // Use temp to fill V
        for (i=1; i<N-1; ++i){
            for (j=1; j<N-1; ++j){
                V(i, j) = temp(i, j);
            }
        }
    }

    // Print out the result
    std::cout << V << std::endl;

    // Clean up Pooma and report success.
    Pooma::finalize();
    return 0;
}

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: Sequential.cpp,v $   $Author: richard $
// $Revision: 1.6 $   $Date: 2004/11/01 18:16:03 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
