// -*- C++ -*-
//
// Copyright (C) 1998, 1999, 2000, 2002  Los Alamos National Laboratory,
// Copyright (C) 1998, 1999, 2000, 2002  CodeSourcery, LLC
//
// This file is part of FreePOOMA.
//
// FreePOOMA is free software; you can redistribute it and/or modify it
// under the terms of the Expat license.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Expat
// license for more details.
//
// You should have received a copy of the Expat license along with
// FreePOOMA; see the file LICENSE.
//
//-----------------------------------------------------------------------------
// Contents:
//   stats function for Jacobi example
//-----------------------------------------------------------------------------

// include files

#include "Pooma/Arrays.h"

#include <stdio.h>

void stats(const Array<2> &a, double, double t)
{
  Interval<2> domain( a.domain() );
  int nx = domain[0].length();
  int ny = domain[1].length();

  double x=0;
  for (int i=0; i<nx; ++i)
    for (int j=0; j<ny; ++j)
      x += a(i,j);

  printf("%10.7f %10.7f\n",t,x);
}

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: stats.cpp,v $   $Author: richard $
// $Revision: 1.10 $   $Date: 2004/11/01 18:15:53 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
