// -*- C++ -*-
//
// Copyright (C) 1998, 1999, 2000, 2002  Los Alamos National Laboratory,
// Copyright (C) 1998, 1999, 2000, 2002  CodeSourcery, LLC
//
// This file is part of FreePOOMA.
//
// FreePOOMA is free software; you can redistribute it and/or modify it
// under the terms of the Expat license.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Expat
// license for more details.
//
// You should have received a copy of the Expat license along with
// FreePOOMA; see the file LICENSE.
//

//-----------------------------------------------------------------------------
// Class:
// NinePointIC1Stencil
// Stencil for the IC(1) preconditioner given the NinePoint matrix stencil
//-----------------------------------------------------------------------------

#ifndef POOMA_NINEPOINTIC1STENCIL_H
#define POOMA_NINEPOINTIC1STENCIL_H

#include <iostream>

class NinePointIC1Stencil {

public : 

   NinePointIC1Stencil () { }

   NinePointIC1Stencil (double sw, double s, double se, double ese,
      double w2, double w, double c) {
      southwest_m = sw;
      south_m = s;
      southeast_m = se;
      ese_m = ese;
      w2_m = w2;
      west_m = w;
      center_m = c; }

   NinePointIC1Stencil &operator= (const NinePointIC1Stencil &in) {
      southwest_m = in.southwest_m;
      south_m = in.south_m;
      southeast_m = in.southeast_m;
      ese_m = in.ese_m;
      w2_m = in.w2_m;
      west_m = in.west_m;
      center_m = in.center_m;
      return * this; }

   NinePointIC1Stencil kludge() { return NinePointIC1Stencil (
      southwest_m, south_m, southeast_m, ese_m, w2_m, west_m,
      1.0 / center_m); }

   inline double &southwest() { return southwest_m; }
   inline double &south() { return south_m; }
   inline double &southeast() { return southeast_m; }
   inline double &ese() { return ese_m; }
   inline double &w2() { return w2_m; }
   inline double &west() { return west_m; }
   inline double &center() { return center_m; }

   inline const double &southwest() const { return southwest_m; }
   inline const double &south() const { return south_m; }
   inline const double &southeast() const { return southeast_m; }
   inline const double &ese() const { return ese_m; }
   inline const double &w2() const { return w2_m; }
   inline const double &west() const { return west_m; }
   inline const double &center() const { return center_m; }

   void print() {
      std::cout << "("; 
      std::cout << southwest_m << ", "; 
      std::cout << south_m << ", "; 
      std::cout << southeast_m << ", "; 
      std::cout << ese_m << ", "; 
      std::cout << w2_m << ", "; 
      std::cout << west_m << ", "; 
      std::cout << center_m << ")" << std::endl; 
      return; }

   ~NinePointIC1Stencil () { }

private:

   double southwest_m;
   double south_m;
   double southeast_m;
   double ese_m;
   double w2_m;
   double west_m;
   double center_m;

}; // end class NinePointIC1Stencil

   std::ostream& operator<< (std::ostream& s, const NinePointIC1Stencil& c) {
      return s << "( " << c.southwest() << ", " << c.south() << ", " <<
      c.southeast() << ", " << c.ese() << ", " << c.w2() << ", " <<
      c.west() << ", " << c.center() << ")" ; }

#endif // POOMA_NINEPOINTIC1STENCIL_H
