// -*- C++ -*-
//
// Copyright (C) 1998, 1999, 2000, 2002  Los Alamos National Laboratory,
// Copyright (C) 1998, 1999, 2000, 2002  CodeSourcery, LLC
//
// This file is part of FreePOOMA.
//
// FreePOOMA is free software; you can redistribute it and/or modify it
// under the terms of the Expat license.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Expat
// license for more details.
//
// You should have received a copy of the Expat license along with
// FreePOOMA; see the file LICENSE.
//

//-----------------------------------------------------------------------------
// Class:
// NinePointIC0Stencil
// Stencil for the IC(0) preconditioner given the NinePoint matrix stencil
//-----------------------------------------------------------------------------

#ifndef POOMA_NINEPOINTIC0STENCIL_H
#define POOMA_NINEPOINTIC0STENCIL_H

#include <iostream>

class NinePointIC0Stencil {

public : 

   NinePointIC0Stencil () { }

   NinePointIC0Stencil (double sw, double s, double se, double w, double c) {
      southwest_m = sw;
      south_m = s;
      southeast_m = se;
      west_m = w;
      center_m = c; }

   NinePointIC0Stencil &operator= (const NinePointIC0Stencil &in) {
      southwest_m = in.southwest_m;
      south_m = in.south_m;
      southeast_m = in.southeast_m;
      west_m = in.west_m;
      center_m = in.center_m;
      return * this; }

  NinePointIC0Stencil kludge () {
    return NinePointIC0Stencil (southwest_m, south_m, southeast_m,
       west_m, 1.0 / center_m); }

   inline double &southwest() { return southwest_m; }
   inline double &south() { return south_m; }
   inline double &southeast() { return southeast_m; }
   inline double &west() { return west_m; }
   inline double &center() { return center_m; }

   inline const double &southwest() const { return southwest_m; }
   inline const double &south() const { return south_m; }
   inline const double &southeast() const { return southeast_m; }
   inline const double &west() const { return west_m; }
   inline const double &center() const { return center_m; }

   void print() {
      std::cout << "("; 
      std::cout << southwest_m << ", "; 
      std::cout << south_m << ", "; 
      std::cout << southeast_m << ", "; 
      std::cout << west_m << ", "; 
      std::cout << center_m << ")" << std::endl; 
      return; }

   ~NinePointIC0Stencil () { }

private:
   double southwest_m;
   double south_m;
   double southeast_m;
   double west_m;
   double center_m;

}; // end class NinePointIC0Stencil

std::ostream& operator<< (std::ostream& s, const NinePointIC0Stencil& c)
{
   return s << "( " << c.southwest() << ", " <<
      c.south() << ", " << c.southeast() << ", " <<
      c.west() << ", " << c.center() << ")" ; }

#endif // POOMA_NINEPOINTIC0STENCIL_H
