/*
*
* Template Numerical Toolkit (TNT): Linear Algebra Module
*
* Mathematical and Computational Sciences Division
* National Institute of Technology,
* Gaithersburg, MD USA
*
*
* This software was developed at the National Institute of Standards and
* Technology (NIST) by employees of the Federal Government in the course
* of their official duties. Pursuant to title 17 Section 105 of the
* United States Code, this software is not subject to copyright protection
* and is in the public domain.  The Template Numerical Toolkit (TNT) is
* an experimental system.  NIST assumes no responsibility whatsoever for
* its use by other parties, and makes no guarantees, expressed or implied,
* about its quality, reliability, or any other characteristic.
*
* BETA VERSION INCOMPLETE AND SUBJECT TO CHANGE
* see http://math.nist.gov/tnt for latest updates.
*
*/

// Test Cholesky module  

#include <iostream>

#include "tnt/tnt.h"
#include "tnt/vec.h"
#include "tnt/fmat.h"
#include "tnt/cholesky.h"
#include "tnt/trisolve.h"
#include "tnt/transv.h"         /* transpose views */

using namespace std;
using namespace TNT;

int main()
{
    Fortran_Matrix<double> A;

    cin >> A;                   /* A should be symmetric positive definite */

    Subscript N = A.num_rows();
    assert(N == A.num_cols());

    Vector<double> b(N, 1.0);   // b= [1,1,1,...]
    Fortran_Matrix<double> L(N, N);


    cout << "A: " << A << endl;
    
    if (Cholesky_upper_factorization(A, L) !=0)
    {
        cout << "Cholesky did not work." << endl;
        exit(1);
    }
    

    cout << L << endl;

    // solve Ax =b, as L*L'x =b
    //
    //  let y=L'x, then
    //
    //
    //   solve L y = b;
    //   solve L'x = y;

    Vector<double> y = Lower_triangular_solve(L, b);
    TNT::Transpose_View<TNT::Fortran_Matrix<double> > foo(L);
    Vector<double> x1=
      Upper_triangular_solve(Transpose_View<Fortran_Matrix<double> >(L), y);
    Vector<double> x= Upper_triangular_solve(foo, y);

    cout << "x: " << x << endl;
    cout << "Residual A*x-b: " << A*x-b << endl;

	return 0;
}
