########################################################################

# ODIR is where all files created by running make will be placed.
#
# $(UNIQUE)_OBJS and/or $(UNIQUE)_LIBS should contain the pathnames of
# any objs to be linked into a product at a higher level in the tree.
# If this directory produces a library, set $(UNIQUE)_LIBS to the
# library path, and LOCAL_OBJS to the object files that make up the lib.
# The entries for these three variables go in ./objfile.mk
# If you do not want make to remove LOCAL_OBJS, add LOCAL_OBJS to
# PROJECT_INTERMEDIATES.
#     PROJECT_INTERMEDIATES += $(LOCAL_OBJS)
#
# e.g.
#     $(UNIQUE)_OBJS	:= $(ODIR)/file1.o $(ODIR)/file2.o
#     LOCAL_OBJS	:= $(ODIR)/file3.o $(ODIR)/file4.o
#     $(UNIQUE)_LIBS	:= $(ODIR)/libThis.a
#     // $(ODIR)/file1.o and $(ODIR)/file2.o are standalone objects
#     //    that are dependencies of some higher level target.
#     // $(ODIR)/file3.o and $(ODIR)/file4.o are Archived to produce
#     //    $(ODIR)/libThis.a which is a dependency of some higher level
#     //    target.
########################################################################

ODIR   := $(THISDIR)/$(SUITE)

UNIQUE := $(subst /,_,$(subst $(PROJECT_ROOT)/,,$(THISDIR)))


# ACL:rcsinfo
#  ----------------------------------------------------------------------
#  $RCSfile: include2.mk,v $   $Author: richard $
#  $Revision: 1.5 $   $Date: 2004/11/01 18:15:22 $
#  ----------------------------------------------------------------------
# ACL:rcsinfo
