/* -*- C -*- */
/*
   Copyright (C) 1998, 1999, 2000, 2002  Los Alamos National Laboratory,
   Copyright (C) 1998, 1999, 2000, 2002  CodeSourcery, LLC

   This file is part of FreePOOMA.

   FreePOOMA is free software; you can redistribute it and/or modify it
   under the terms of the Expat license.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Expat
   license for more details.

   You should have received a copy of the Expat license along with
   FreePOOMA; see the file LICENSE.
 */

/* include files */

#include "Pooma/Configuration.h"


/* wrapper for integrated C/C++ compilers */

#ifdef __cplusplus
extern "C" {
#endif


/* rbSOR Kernel */

void runInC(double* a, int n)
{
  const double fact = 1.0 / 5.0;
  int i, j, k;

  // Run kernel.
    
  for (k = 0; k < 10; ++k)
  {
    // red
    for (j = 1; j <= n-3; j+=2) 
    {
      for (i = 1; i <= n-3; i+=2) 
      {
	a[i+n*j] = fact * ( a[i-1+n*j] + a[i+1+n*j] + a[i+n*j] +
          a[i+n*(j-1)] + a[i+n*(j+1)] );
	a[i+1+n*(j+1)] = fact * ( a[i+n*(j+1)] + a[i+2+n*(j+1)] +
          a[i+1+n*(j+1)] + a[i+1+n*j] + a[i+1+n*(j+2)] );
      }
    }
    // black
    for (j = 1; j <= n-3; j+=2) 
    {
      for (i = 1; i <= n-3; i+=2) 
      {
	a[i+1+n*j] = fact * ( a[i+n*j] + a[i+2+n*j] + a[i+1+n*j] +
          a[i+1+n*(j-1)] + a[i+1+n*(j+1)] );
	a[i+n*(j+1)] = fact * ( a[i-1+n*(j+1)] + a[i+1+n*(j+1)] +
          a[i+n*(j+1)] + a[i+n*j] + a[i+n*(j+2)] );
      }
    }
  }
}

void runInCRestrict(double* restrict a, int n)
{
  const double fact = 1.0 / 5.0;
  int i, j, k;

  // Run kernel.
    
  for (k = 0; k < 10; ++k)
  {
    // red
    for (j = 1; j <= n-3; j+=2) 
    {
      for (i = 1; i <= n-3; i+=2) 
      {
	a[i+n*j] = fact * ( a[i-1+n*j] + a[i+1+n*j] + a[i+n*j] +
          a[i+n*(j-1)] + a[i+n*(j+1)] );
	a[i+1+n*(j+1)] = fact * ( a[i+n*(j+1)] + a[i+2+n*(j+1)] +
          a[i+1+n*(j+1)] + a[i+1+n*j] + a[i+1+n*(j+2)] );
      }
    }
    // black
    for (j = 1; j <= n-3; j+=2) 
    {
      for (i = 1; i <= n-3; i+=2) 
      {
	a[i+1+n*j] = fact * ( a[i+n*j] + a[i+2+n*j] + a[i+1+n*j] +
          a[i+1+n*(j-1)] + a[i+1+n*(j+1)] );
	a[i+n*(j+1)] = fact * ( a[i-1+n*(j+1)] + a[i+1+n*(j+1)] +
          a[i+n*(j+1)] + a[i+n*j] + a[i+n*(j+2)] );
      }
    }
  }
}

#ifdef __cplusplus
}
#endif

/* ACL:rcsinfo */
/* ----------------------------------------------------------------------
 * $RCSfile: rbSORinC.c,v $   $Author: richard $
 * $Revision: 1.3 $   $Date: 2004/11/01 18:15:19 $
 * ----------------------------------------------------------------------
 */
/* ACL:rcsinfo */

