// -*- C++ -*-
//
// Copyright (C) 1998, 1999, 2000, 2002  Los Alamos National Laboratory,
// Copyright (C) 1998, 1999, 2000, 2002  CodeSourcery, LLC
//
// This file is part of FreePOOMA.
//
// FreePOOMA is free software; you can redistribute it and/or modify it
// under the terms of the Expat license.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Expat
// license for more details.
//
// You should have received a copy of the Expat license along with
// FreePOOMA; see the file LICENSE.
//

//-----------------------------------------------------------------------
// rbSOR Benchmark (UMP version)
//-----------------------------------------------------------------------

// Include files

#include "Pooma/Pooma.h"
#include "rbSORinC.h"
#include "rbSORinCppTran.h"
#include "rbSORinP2.h"


//-----------------------------------------------------------------------
// Main program.
//-----------------------------------------------------------------------

int main(int argc, char* argv[])
{
  Pooma::initialize(argc, argv); 
  
  Benchmark rbsor(argc, argv);

#if !POOMA_NO_RESTRICT
  rbsor.addImplementation(new rbsorC<true>);
#endif
  rbsor.addImplementation(new rbsorC<false>);
  rbsor.addImplementation(new rbsorCppTran<Brick,false>);
  rbsor.addImplementation(new rbsorP2<Brick,false>);
  rbsor.addImplementation(new rbsorCppTran<Brick,true>);
  rbsor.addImplementation(new rbsorP2<Brick,true>);
  
  rbsor.setSamplingParameters(100,0,1);
  rbsor.setIterations(100);
  rbsor.run();
  
  Pooma::finalize();

  return 0;
}

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: rbSOR.cpp,v $   $Author: richard $
// $Revision: 1.5 $   $Date: 2004/11/01 18:15:19 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
