/* -*- C -*- */
/*
   Copyright (C) 1998, 1999, 2000, 2002  Los Alamos National Laboratory,
   Copyright (C) 1998, 1999, 2000, 2002  CodeSourcery, LLC

   This file is part of FreePOOMA.

   FreePOOMA is free software; you can redistribute it and/or modify it
   under the terms of the Expat license.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Expat
   license for more details.

   You should have received a copy of the Expat license along with
   FreePOOMA; see the file LICENSE.
 */

/* include files */

#include "Pooma/Configuration.h"


/* wrapper for integrated C/C++ compilers */

#ifdef __cplusplus
extern "C" {
#endif


/* atest kernels */

void
runatestInCwithout(double* w, double* x, 
                   double* y, double* z, int n) {
  int i, j;
  for (j = 0; j < n; j++) {
    for (i = 0; i < n; i++) {
      w[i + n * j] += x[i + n * j] + y[i + n * j] + z[i + n * j];
    }
  }
}


void 
runatestInCwith(double* restrict w, double* x, 
                double* y, double* z, int n) {
  int i, j;
  for (j = 0; j < n; j++) {
    for (i = 0; i < n; i++) {
      w[i + n * j] += x[i + n * j] + y[i + n * j] + z[i + n * j];
    }
  }
}

#ifdef __cplusplus
}
#endif

/* ACL:rcsinfo */
/* ----------------------------------------------------------------------
 * $RCSfile: atestInC.c,v $   $Author: richard $
 * $Revision: 1.10 $   $Date: 2004/11/01 18:15:16 $
 * ----------------------------------------------------------------------
 */
/* ACL:rcsinfo */
