// -*- C++ -*-
//
// Copyright (C) 1998, 1999, 2000, 2002  Los Alamos National Laboratory,
// Copyright (C) 1998, 1999, 2000, 2002  CodeSourcery, LLC
//
// This file is part of FreePOOMA.
//
// FreePOOMA is free software; you can redistribute it and/or modify it
// under the terms of the Expat license.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Expat
// license for more details.
//
// You should have received a copy of the Expat license along with
// FreePOOMA; see the file LICENSE.
//
//-----------------------------------------------------------------------------
// SimpleArray Benchmark
//-----------------------------------------------------------------------------

// include files

#include "atestInP2.h"
#include "atestInCppTran.h"
#include "atestInC.h"


//-----------------------------------------------------------------------------
// Main program.
//-----------------------------------------------------------------------------

int main(int argc, char* argv[])
{
  Pooma::initialize(argc, argv);
  
  // Run SimpleArray benchmark in Pooma II, CppTran, and C without and
  // with restrict.

  Benchmark atest(argc, argv);

  atest.addImplementation(new atestInCwithout);
#if !POOMA_NO_RESTRICT
  atest.addImplementation(new atestInCwith);
#endif
  atest.addImplementation(new atestInCppTran);
  atest.addImplementation(new atestInP2);

  atest.setSamplingParameters(10,2,3);
  atest.run();

  Pooma::finalize();

  return 0;
}

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: atest.cpp,v $   $Author: richard $
// $Revision: 1.12 $   $Date: 2004/11/01 18:15:16 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
