// -*- C++ -*-
//
// Copyright (C) 1998, 1999, 2000, 2002  Los Alamos National Laboratory,
// Copyright (C) 1998, 1999, 2000, 2002  CodeSourcery, LLC
//
// This file is part of FreePOOMA.
//
// FreePOOMA is free software; you can redistribute it and/or modify it
// under the terms of the Expat license.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Expat
// license for more details.
//
// You should have received a copy of the Expat license along with
// FreePOOMA; see the file LICENSE.
//
//-----------------------------------------------------------------------------
// GKPoisson Benchmark
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Include files
//-----------------------------------------------------------------------------

#include "GKPoissonInP2.h"

//-----------------------------------------------------------------------------
// Main program.
//-----------------------------------------------------------------------------

#if defined(__MWERKS__)
#pragma optimization_level 2
#endif

void mpcase(Benchmark &bm)
{
  GKPoissonInP2MP* gkpP2MP = new GKPoissonInP2MP(0.95);
  gkpP2MP->setNumPatches(bm.numPatches());
  bm.addImplementation(gkpP2MP);
}

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: GKPoissonMP.cpp,v $   $Author: richard $
// $Revision: 1.3 $   $Date: 2004/11/01 18:15:13 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
