/* -*- C -*- */
/*
   Copyright (C) 1998, 1999, 2000, 2002  Los Alamos National Laboratory,
   Copyright (C) 1998, 1999, 2000, 2002  CodeSourcery, LLC

   This file is part of FreePOOMA.

   FreePOOMA is free software; you can redistribute it and/or modify it
   under the terms of the Expat license.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Expat
   license for more details.

   You should have received a copy of the Expat license along with
   FreePOOMA; see the file LICENSE.
 */

/* include files */

#include "Pooma/Configuration.h"


/* wrapper for integrated C/C++ compilers */

#ifdef __cplusplus
extern "C" {
#endif

/* GKPoisson kernels */

void setInitialConditionsInC(double* restrict phi, 
			     double* restrict density, 
			     double* restrict phihat, 
			     double gamma0, int n)
{
  /* Initialize the arrays. */

  int i, j;

  const int nmax = n + 4;

  int nd = n / 2;

  for (j = 0; j < nmax; ++j)
    {
      for (i = 0; i < nmax; ++i) 
	{
	  phi    [i + nmax * j] = 0.0;
	  phihat [i + nmax * j] = 0.0;
	  density[i + nmax * j] = 0.0;
	}
    }

  /* Delta-function density */
  
  density[nd + 2 + nmax * (nd + 2)] = 1000.;
  phi    [nd + 2 + nmax * (nd + 2)] = 1000.*gamma0;
}


void runGKPoissonInC(double* restrict phi, double* density, 
		     double* restrict phihat, double gamma0, int n)
{
  int i, j, iter;
  const double ijfact = 0.25 - gamma0;
  const double norm   = 1./(2.0 - gamma0);

  const int nmax = n + 4;

  setInitialConditionsInC(phi,density,phihat,gamma0,n);

  for (iter = 0; iter < 5; ++iter)
    {
      for (j = 2; j < n + 2; ++j) 
	{
	  for (i = 2; i < n + 2; ++i) 
	    {
	      phihat[i + nmax * j] = density[i + nmax * j] 

		+ ijfact * phi[i + nmax * j] 
		
		+ 0.125  * ( phi[i + 1 + nmax * (j + 1)] +
			     phi[i + 1 + nmax * (j - 1)] +
			     phi[i - 1 + nmax * (j + 1)] +
			     phi[i - 1 + nmax * (j - 1)] )

		+ 0.0625 * ( phi[i     + nmax * (j + 2)] +
			     phi[i     + nmax * (j - 2)] +
			     phi[i + 2 + nmax * (j    )] +
			     phi[i - 2 + nmax * (j    )] );
	    }
	}

      for (j = 2; j < n + 2; ++j) 
	{
	  for (i = 2; i < n + 2; ++i) 
	    {
	      phi[i + nmax * j] = norm * phihat[i + nmax * j];
	    }
	}
    }
}

#ifdef __cplusplus
}
#endif

/* ACL:rcsinfo */
/* ----------------------------------------------------------------------
 * $RCSfile: GKPoissonInC.c,v $   $Author: richard $
 * $Revision: 1.8 $   $Date: 2004/11/01 18:15:13 $
 * ----------------------------------------------------------------------
 */
/* ACL:rcsinfo */
