// -*- C++ -*-
//
// Copyright (C) 1998, 1999, 2000, 2002  Los Alamos National Laboratory,
// Copyright (C) 1998, 1999, 2000, 2002  CodeSourcery, LLC
//
// This file is part of FreePOOMA.
//
// FreePOOMA is free software; you can redistribute it and/or modify it
// under the terms of the Expat license.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Expat
// license for more details.
//
// You should have received a copy of the Expat license along with
// FreePOOMA; see the file LICENSE.
//
//-----------------------------------------------------------------------------
// Doof2d Benchmark
//-----------------------------------------------------------------------------

// Include files

#include "Pooma/Pooma.h"
#include "Doof2d.h"
#include "Doof2dInC.h"

#if POOMA_CHEETAH
  typedef Remote<Brick> BrickTag_t;
  typedef Remote<CompressibleBrick> CompressibleBrickTag_t;
#else
  typedef Brick BrickTag_t;
  typedef CompressibleBrick CompressibleBrickTag_t;
#endif

//-----------------------------------------------------------------------------
// Main program.
//-----------------------------------------------------------------------------

int main(int argc, char* argv[])
{
  Pooma::initialize(argc, argv); 
  
  Benchmark doof2d(argc, argv);

  typedef Array<2, double, BrickTag_t>
    BrickStore_t;
  typedef Array<2, double, CompressibleBrickTag_t>
    CompBrickStore_t;
  typedef Array<2, double, MultiPatch<UniformTag, BrickTag_t> >
    MPBrickStore_t;
  typedef Array<2, double, MultiPatch<UniformTag, CompressibleBrickTag_t> >
    MPCompBrickStore_t;

  typedef Field<UniformRectilinearMesh<2>, double, BrickTag_t>
    FBrickStore_t;
  typedef Field<UniformRectilinearMesh<2>, double, CompressibleBrickTag_t>
    FCompBrickStore_t;
  typedef Field<UniformRectilinearMesh<2>, double,
                MultiPatch<UniformTag, BrickTag_t> >
    FMPBrickStore_t;
  typedef Field<UniformRectilinearMesh<2>, double,
                MultiPatch<UniformTag, CompressibleBrickTag_t> >
    FMPCompBrickStore_t;

  // C versions
#if !POOMA_NO_RESTRICT
  doof2d.addImplementation(new Doof2dInC<true>());
#endif
  doof2d.addImplementation(new Doof2dInC<false>());
 
  // CppTran version Brick
  doof2d.addImplementation(new Doof2dCppTran<BrickStore_t>);

  // Brick single patch
  doof2d.addImplementation(new Doof2dP2<BrickStore_t>);

  // Compressible Brick single patch
  doof2d.addImplementation(new Doof2dP2<CompBrickStore_t>);

  // Brick multi-patch no guards
  doof2d.addImplementation(new Doof2dP2<MPBrickStore_t>(doof2d.numPatches()));

  // Brick multi-patch with 1 guard layer
  doof2d.addImplementation(new Doof2dP2<MPBrickStore_t>(doof2d.numPatches(),1));

  // Brick multi-patch with 1 guard layer using stencil object
  doof2d.addImplementation(new Doof2dP2Opt<MPBrickStore_t>(doof2d.numPatches(),1));

  // Compressible brick multi-patch no guard layers
  doof2d.addImplementation(new Doof2dP2<MPCompBrickStore_t>(doof2d.numPatches()));

  // Compressible brick multi-patch with 1 guard layer
  doof2d.addImplementation(new Doof2dP2<MPCompBrickStore_t>(doof2d.numPatches(),1));

  // Compressible brick multi-patch with 1 guard layer using stencil object
  doof2d.addImplementation(new Doof2dP2Opt<MPCompBrickStore_t>(doof2d.numPatches(),1));

  // Field CppTran version Brick
  doof2d.addImplementation(new Doof2dCppTran<FBrickStore_t>);

  // Field Brick single patch
  doof2d.addImplementation(new Doof2dP2<FBrickStore_t>);

  // Field Compressible Brick single patch
  doof2d.addImplementation(new Doof2dP2<FCompBrickStore_t>);

  // Field Brick multi-patch no guards
  doof2d.addImplementation(new Doof2dP2<FMPBrickStore_t>(doof2d.numPatches()));

  // Field Brick multi-patch with 1 guard layer
  doof2d.addImplementation(new Doof2dP2<FMPBrickStore_t>(doof2d.numPatches(),1));

  // Field Compressible brick multi-patch no guard layers
  doof2d.addImplementation(new Doof2dP2<FMPCompBrickStore_t>(doof2d.numPatches()));

  // Field Compressible brick multi-patch with 1 guard layer
  doof2d.addImplementation(new Doof2dP2<FMPCompBrickStore_t>(doof2d.numPatches(),1));

  // Need to add implementations for stencils on Field.

  doof2d.setSamplingParameters(100,0,1);
  doof2d.run();
  
  Pooma::finalize();

  return 0;
}

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: Doof2d.cpp,v $   $Author: richard $
// $Revision: 1.21 $   $Date: 2004/11/01 18:15:11 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
