/* -*- C -*- */
/*
   Copyright (C) 1998, 1999, 2000, 2002  Los Alamos National Laboratory,
   Copyright (C) 1998, 1999, 2000, 2002  CodeSourcery, LLC

   This file is part of FreePOOMA.

   FreePOOMA is free software; you can redistribute it and/or modify it
   under the terms of the Expat license.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Expat
   license for more details.

   You should have received a copy of the Expat license along with
   FreePOOMA; see the file LICENSE.
 */

/* include files */

#include "Pooma/Configuration.h"


/* wrapper for integrated C/C++ compilers */

#ifdef __cplusplus
extern "C" {
#endif


/* Acoustic2d kernel */

void 
runAcoustic2dInC(double* restrict p1, double* restrict p2, double* restrict p3,
                 double* c, int N, int Niters)
{
  int i, j, iter;
  for (iter = 1; iter <= Niters; iter++)
  {
    for (j = 2; j <= N - 1; j++)
      for (i = 2; i <= N - 1; i++)
        p3[i-1 + N*(j-1)] = (2 - 4 * c[i-1 + N*(j-1)]) * p2[i-1 + N*(j-1)] +
          c[i-1 + N*(j-1)] * (p2[i-1 + N*(j-2)] + p2[i-1 + N*j] +
                              p2[i-2 + N*(j-1)] + p2[i + N*(j-1)]) - 
          p1[i-1 + N*(j-1)];
               
    for (j = 1; j <= N; j++)
      for (i = 1; i <= N; i++)
      {
        p1[i-1 + N*(j-1)] = p2[i-1 + N*(j-1)];
        p2[i-1 + N*(j-1)] = p3[i-1 + N*(j-1)];
      }
  }
}

#ifdef __cplusplus
}
#endif

/* ACL:rcsinfo */
/* ----------------------------------------------------------------------
 * $RCSfile: Acoustic2dInC.c,v $   $Author: richard $
 * $Revision: 1.9 $   $Date: 2004/11/01 18:15:03 $
 * ----------------------------------------------------------------------
 */
/* ACL:rcsinfo */
