// -*- C++ -*-
//
// Copyright (C) 1998, 1999, 2000, 2002  Los Alamos National Laboratory,
// Copyright (C) 1998, 1999, 2000, 2002  CodeSourcery, LLC
//
// This file is part of FreePOOMA.
//
// FreePOOMA is free software; you can redistribute it and/or modify it
// under the terms of the Expat license.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Expat
// license for more details.
//
// You should have received a copy of the Expat license along with
// FreePOOMA; see the file LICENSE.
//
//-----------------------------------------------------------------------------
// 2D acoustic benchmark.
// Based on the Blitz++ version by Todd Veldhuizen.
// See http://monet.uwaterloo.ca/blitz/benchmarks/acoustic.html.
//-----------------------------------------------------------------------------

// include files

#include "Acoustic2dInC.h"
#include "Acoustic2dInCppTran.h"
#include "Acoustic2dInP2.h"

//-----------------------------------------------------------------------------
// Main program.
//-----------------------------------------------------------------------------

int main(int argc, char *argv[])
{
  Pooma::initialize(argc, argv);

  Benchmark acoustic2d(argc, argv);
  
  acoustic2d.addImplementation(new Acoustic2dInC<double, 50>);
  acoustic2d.addImplementation(new Acoustic2dInCppTran<double, 50>);
  acoustic2d.addImplementation(new Acoustic2dInP2<double, 50>);

  acoustic2d.setSamplingParameters(10,1,4);
  acoustic2d.setIterations(100);  
  acoustic2d.run();

  Pooma::finalize();
    
  return 0;
}

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: Acoustic2d.cpp,v $   $Author: richard $
// $Revision: 1.15 $   $Date: 2004/11/01 18:15:03 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
