// -*- C++ -*-
//
// Copyright (C) 1998, 1999, 2000, 2002  Los Alamos National Laboratory,
// Copyright (C) 1998, 1999, 2000, 2002  CodeSourcery, LLC
//
// This file is part of FreePOOMA.
//
// FreePOOMA is free software; you can redistribute it and/or modify it
// under the terms of the Expat license.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Expat
// license for more details.
//
// You should have received a copy of the Expat license along with
// FreePOOMA; see the file LICENSE.
//
//-----------------------------------------------------------------------------
// ABC Benchmark
//-----------------------------------------------------------------------------

// Include files

#include "Pooma/Pooma.h"
#include "ABC.h"
#include "ABCInC.h"

#if POOMA_CHEETAH
  typedef Remote<Brick> BrickTag_t;
  typedef Remote<CompressibleBrick> CompressibleBrickTag_t;
#else
  typedef Brick BrickTag_t;
  typedef CompressibleBrick CompressibleBrickTag_t;
#endif

//-----------------------------------------------------------------------------
// Main program.
//-----------------------------------------------------------------------------

int main(int argc, char* argv[])
{
  Pooma::initialize(argc, argv); 
  
  Benchmark abc(argc, argv);

  typedef Array<2, double, BrickTag_t>
    BrickStore_t;
  typedef Array<2, double, CompressibleBrickTag_t>
    CompBrickStore_t;
  typedef Array<2, double, MultiPatch<UniformTag, BrickTag_t> >
    MPBrickStore_t;
  typedef Array<2, double, MultiPatch<UniformTag, CompressibleBrickTag_t> >
    MPCompBrickStore_t;

  typedef Field<UniformRectilinearMesh<2>, double, BrickTag_t>
    FBrickStore_t;
  typedef Field<UniformRectilinearMesh<2>, double, CompressibleBrickTag_t>
    FCompBrickStore_t;
  typedef Field<UniformRectilinearMesh<2>, double,
                MultiPatch<UniformTag, BrickTag_t> >
    FMPBrickStore_t;
  typedef Field<UniformRectilinearMesh<2>, double,
                MultiPatch<UniformTag, CompressibleBrickTag_t> >
    FMPCompBrickStore_t;

  // C versions
#if !POOMA_NO_RESTRICT
  abc.addImplementation(new AbcInC<true>());
#endif
  abc.addImplementation(new AbcInC<false>());
 
  // CppTran version Brick
  abc.addImplementation(new AbcCppTran<BrickStore_t>);

  // Brick single patch
  abc.addImplementation(new AbcP2<BrickStore_t>);

  // Compressible Brick single patch
  abc.addImplementation(new AbcP2<CompBrickStore_t>);

  // Brick multi-patch no guards
  abc.addImplementation(new AbcP2<MPBrickStore_t>(abc.numPatches()));

  // Brick multi-patch with 1 guard layer
  abc.addImplementation(new AbcP2<MPBrickStore_t>(abc.numPatches(),1));

  // Compressible brick multi-patch no guard layers
  abc.addImplementation(new AbcP2<MPCompBrickStore_t>(abc.numPatches()));

  // Compressible brick multi-patch with 1 guard layer
  abc.addImplementation(new AbcP2<MPCompBrickStore_t>(abc.numPatches(),1));

  // Field CppTran version Brick
  abc.addImplementation(new AbcCppTran<FBrickStore_t>);

  // Field Brick single patch
  abc.addImplementation(new AbcP2<FBrickStore_t>);

  // Field Compressible Brick single patch
  abc.addImplementation(new AbcP2<FCompBrickStore_t>);

  // Field Brick multi-patch no guards
  abc.addImplementation(new AbcP2<FMPBrickStore_t>(abc.numPatches()));

  // Field Brick multi-patch with 1 guard layer
  abc.addImplementation(new AbcP2<FMPBrickStore_t>(abc.numPatches(),1));

  // Field Compressible brick multi-patch no guard layers
  abc.addImplementation(new AbcP2<FMPCompBrickStore_t>(abc.numPatches()));

  // Field Compressible brick multi-patch with 1 guard layer
  abc.addImplementation(new AbcP2<FMPCompBrickStore_t>(abc.numPatches(),1));

  abc.setSamplingParameters(100,0,1);
  abc.run();
  
  Pooma::finalize();

  return 0;
}

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: ABC.cpp,v $   $Author: richard $
// $Revision: 1.10 $   $Date: 2004/11/01 18:15:02 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
