/********************************************************************************
                                   main.cpp
                               -------------------
           begin                : lun jui 14 19:50:56 CEST 2003
       copyright                : (C) 2003 by Thomas Silvi
           email                : thomas.silvi@laposte.net
*********************************************************************************/

/********************************************************************************
*                                                                               *
*   This file is part of the Escort Tools Suite program.                        *
*                                                                               *
*   Escort Tools Suite is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by        *
*   the Free Software Foundation; either version 2 of the License, or           *
*   (at your option) any later version.                                         *
*                                                                               *
*   Escort Tools Suite is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
*   GNU General Public License for more details.                                *
*                                                                               *
*   You should have received a copy of the GNU General Public License           *
*   along with Escort Tools Suite; if not, write to the Free Software           *
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA   *
*                                                                               *
*********************************************************************************/

#include "Config.h"
#include "Misc.h"
#include "Launcher.h"
#include "ToolSuiteConfig.h"

#include <X11/Xlib.h>

#include <kapplication.h>
#include <kcmdlineargs.h>
#include <klocale.h>
#include <kaboutdata.h>
#include <qarray.h>

// global variables

QArray<QString> toolsArray;
unsigned int toolWindowsNumber;

// local variables 

//QString toolsList[] = { "Query Tool", "Workflow Tool", 0 };
QString toolsList[] = { "Query Tool", 0 };

static QString default_tool = "Query Tool";


static const char *description = I18N_NOOP("Escort Tool Suite : a Kde tool suite for Postgres Sql");

static KCmdLineOptions options[] =
{
	{ "t <tool name>", I18N_NOOP("launch tool name instead of default"), default_tool },
	KCmdLineLastOption
};


int main (int argc,char *argv[])
{
	if (XInitThreads() == 0) 
	{ 
		printf("Warning main.cpp> Xlib does no handle thread.\n"); 
	}

	QString errorMessage;

	// compute some init values

	dataPath = dataPath + applicationName +"/";

	if (replaceTildaByHomeDirectory(dataPath, errorMessage) == false) 
	{ 
		printf ("Error : %s (main.cpp)\n", errorMessage.ascii()); 
		exit(1); 
	}

	toolsArray.setRawData(toolsList,sizeof(toolsList));

	// set global variables

	toolWindowsNumber = 0;

	KAboutData aboutData (applicationName, I18N_NOOP(applicationName),
		version, description, KAboutData::License_GPL,
		"(c) 2003, Thomas Silvi", 0, 0, "thomas.silvi@laposte.net");
	
	aboutData.addAuthor("Thomas Silvi",I18N_NOOP("Creator & Maintainer"),
		"thomas.silvi@laposte.net");
//	aboutData.setHomepage ("///public3/tom_HOME/TomProjectExt/web/to_upload/index.html");

	// parse & run

	KCmdLineArgs::init( argc, argv, &aboutData);
	KCmdLineArgs::addCmdLineOptions( options );
	
	KCmdLineArgs *args;
	
	
	args = KCmdLineArgs::parsedArgs();
	
	KApplication app; 

	Launcher l;

	l.setDefaultTool(default_tool);

	QString toolToLaunch;

	if (l.checkAndFindToolToLaunch(args, toolToLaunch) == false)
	{
		printf ("Error : Invalid tool name : " + toolToLaunch + "\n");
		return -1;
	}



	if (l.launch(toolToLaunch) == 0)
	{
		exit(1);
	}

	return app.exec();
}

