/********************************************************************************
                                TextEditQuery.cpp
                               -------------------
           begin                : lun jui 14 19:50:56 CEST 2003
       copyright                : (C) 2003 by Thomas Silvi
           email                : thomas.silvi@laposte.net
*********************************************************************************/

/********************************************************************************
*                                                                               *
*   This file is part of the Escort Tools Suite program.                        *
*                                                                               *
*   Escort Tools Suite is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by        *
*   the Free Software Foundation; either version 2 of the License, or           *
*   (at your option) any later version.                                         *
*                                                                               *
*   Escort Tools Suite is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
*   GNU General Public License for more details.                                *
*                                                                               *
*   You should have received a copy of the GNU General Public License           *
*   along with Escort Tools Suite; if not, write to the Free Software           *
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA   *
*                                                                               *
*********************************************************************************/

#include "TextEditQuery.h"

#include <qregexp.h>

TextEditQuery::TextEditQuery()
{
	shiftString = "\t";

	setTabChangesFocus(false);
}

TextEditQuery::~TextEditQuery()
{
}

void TextEditQuery::init()
{
	setTextFormat(PlainText);
	setWordWrap(QTextEdit::NoWrap);
	clear();
	setCurrentFont(QFont("Courier",10));
	
	return;
}

void TextEditQuery::removeLastCharacter()
{
	// only newline are removed
	// in order to keep the same style in the whole document

	QString nl("\n");

	while (text().endsWith(nl) == true) 
	{
		moveCursor(QTextEdit::MoveEnd, false);
		moveCursor(QTextEdit::MoveBackward, false);
		del();
	}

	return;
}

void TextEditQuery::keyPressEvent(QKeyEvent *pKeyEvent)
{
	bool thingToDo;

	if (pKeyEvent == 0)
		return;

	thingToDo = true;

//	printf("%d\n",pKeyEvent->key());

	if (this->hasSelectedText() == true)
	{
		switch (pKeyEvent->key())
		{
			case (Qt::Key_Tab) : 
			{
				thingToDo = false;
				shiftSelectedText();
				break;
			}
		}

	}

	if (thingToDo == true)
	{
		KTextEdit::keyPressEvent(pKeyEvent);
	}

	return;
}


void TextEditQuery::shiftSelectedText()
{
	// add shiftString to the beginning of each line of the selection

	QString tmpSelectedText, tmpShiftedSelectedText, tmpPrefix;
	int startLine,col1,endLine,col2;

	this->getSelection(&startLine,&col1,&endLine,&col2);

	if ((col2 == 0) && (endLine>0))
	{
		endLine--;
	}

	col2 = this->paragraphLength(endLine);

	// we change the selection in order that it takes all the entire lines
	this->setSelection(startLine,0,endLine,col2,0);

	// build the shifted text
	tmpSelectedText = this->selectedText();
	tmpPrefix = QChar('\n') + shiftString;
	tmpShiftedSelectedText = shiftString + tmpSelectedText.replace(QChar('\n'),tmpPrefix);

	// change the text = delete + insert
	this->removeSelectedText();
	this->insertAt(tmpShiftedSelectedText,startLine,0);

	// set the selection again
	col2 = this->paragraphLength(endLine);
	this->setSelection(startLine,0,endLine,col2,0);

	return;
}

void TextEditQuery::unshiftSelectedText()
{
printf("TODO : unshift\n");
	// remove shiftString from the beginning of each line of the selection

	QString tmpSelectedText, tmpUnshiftedSelectedText;
	int startLine,col1,endLine,col2;
	QRegExp re;


	this->getSelection(&startLine,&col1,&endLine,&col2);

	if ((col2 == 0) && (endLine>0))
	{
		endLine--;
	}

	col2 = this->paragraphLength(endLine);

	// we change the selection in order that it takes all the entire lines
	this->setSelection(startLine,0,endLine,col2,0);

	// build the unshifted text
	tmpSelectedText = this->selectedText();

	re = QRegExp("\n\t");
//	tmpPrefix = QChar('\n') + shiftString;

	tmpUnshiftedSelectedText = tmpSelectedText.replace(re,"\n");

	// change the text = delete + insert
	this->removeSelectedText();
	this->insertAt(tmpUnshiftedSelectedText,startLine,0);

	// set the selection again
	col2 = this->paragraphLength(endLine);
	this->setSelection(startLine,0,endLine,col2,0);

	return;
}




