/********************************************************************************
                                   QueryEngine.h
                               -------------------
           begin                : lun jui 14 19:50:56 CEST 2003
       copyright                : (C) 2003 by Thomas Silvi
           email                : thomas.silvi@laposte.net
*********************************************************************************/

/********************************************************************************
*                                                                               *
*   This file is part of the Escort Tools Suite program.                        *
*                                                                               *
*   Escort Tools Suite is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by        *
*   the Free Software Foundation; either version 2 of the License, or           *
*   (at your option) any later version.                                         *
*                                                                               *
*   Escort Tools Suite is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
*   GNU General Public License for more details.                                *
*                                                                               *
*   You should have received a copy of the GNU General Public License           *
*   along with Escort Tools Suite; if not, write to the Free Software           *
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA   *
*                                                                               *
*********************************************************************************/

#ifndef QUERY_ENGINE_H
#define QUERY_ENGINE_H

#include "Root.h"
#include "ConnectionParameters.h"

#include <libpq-fe.h>

#include <qstring.h>

#include <klocale.h>


class QueryEngine : public Root
{
	public:

	QueryEngine();
	~QueryEngine();
	
	QString toString() const;
	
	void connect(ConnectionParameters &pConnectionParameters, QString &pErrorMessage);
	ConnStatusType getConnectionState();
	void disconnect();
	ExecStatusType executeQuery(QString *pQuery, QString &pErrorMessage);
	void debugShowResult();
	PGresult * getResults();
	PGconn * getPGConnection();
	ConnectionParameters getConnectionParameters() const;
	
	protected:
	
	ConnectionParameters connectionParameters;
	PGconn  *connection;
	ConnStatusType latestStatus;
	
	PGresult *results;

};

#endif

