/********************************************************************************
                                 QueryEngine.cpp
                               -------------------
           begin                : lun jui 14 19:50:56 CEST 2003
       copyright                : (C) 2003 by Thomas Silvi
           email                : thomas.silvi@laposte.net
*********************************************************************************/

/********************************************************************************
*                                                                               *
*   This file is part of the Escort Tools Suite program.                        *
*                                                                               *
*   Escort Tools Suite is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by        *
*   the Free Software Foundation; either version 2 of the License, or           *
*   (at your option) any later version.                                         *
*                                                                               *
*   Escort Tools Suite is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
*   GNU General Public License for more details.                                *
*                                                                               *
*   You should have received a copy of the GNU General Public License           *
*   along with Escort Tools Suite; if not, write to the Free Software           *
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA   *
*                                                                               *
*********************************************************************************/

#include "QueryEngine.h"

QueryEngine::QueryEngine()
{
	connection = 0;
}

QueryEngine::~QueryEngine()
{
	disconnect();
}

void QueryEngine::connect(ConnectionParameters &pConnectionParameters, 
	QString &pErrorMessage)
{
	QString connectionString;

	pErrorMessage = "";	
	connectionString = pConnectionParameters.buildUrl();
	connectionParameters = pConnectionParameters;

#ifdef DEBUG_APP
	printf("DEBUG_APP QueryEngine::connect> Connection String : %s\n",
		connectionString.ascii());
#endif

	connection = 0;
	connection = PQconnectdb (connectionString.ascii());
	latestStatus = PQstatus(connection);

/*
	if (PQsetnonblocking(connection,1) != 0)
	{
		// error
		PQfinish(connection);
		conn = 0;
		latestStatus = CONNECTION_BAD;
		pErrorMessage = QString(i18n("Connection Error"));
		return;
	}
*/

//printf("ConnStatusType : %d\n",latestStatus);

	if (latestStatus == CONNECTION_BAD)
	{
//printf("Connection to database failed.\n");
		pConnectionParameters.setId(-1);
		pErrorMessage = QString(i18n("Connection Problem to %1\n").arg(PQdb(connection)))
			+ QString(PQerrorMessage(connection));
		return;
	}

	pConnectionParameters.setId(PQbackendPID(connection));

	return;
}

ConnStatusType QueryEngine::getConnectionState()
{
	latestStatus = PQstatus(connection);
	return latestStatus;
}

void QueryEngine::disconnect()
{
	if (connection != 0)
	{
		PQfinish(connection);
		connection = 0;		
	}
	
	return;
}

ExecStatusType QueryEngine::executeQuery(QString *pQuery, QString &pErrorMessage)
{
	ExecStatusType res;
	
	results = PQexec(connection,pQuery->ascii());
	
	res = PQresultStatus(results);
	pErrorMessage = QString(PQerrorMessage(connection));
	
	return res;
}

void QueryEngine::debugShowResult()
{
	return;
}

PGresult * QueryEngine::getResults()
{
	return results;
}

PGconn * QueryEngine::getPGConnection()
{
	return connection;
}

QString QueryEngine::toString() const
{
	return QString("ToDo : QueryEngine");
}

ConnectionParameters QueryEngine::getConnectionParameters() const
{
	return connectionParameters;
}




	
	
	
