/********************************************************************************
                                   OutputViewText.cpp
                               -------------------
           begin                : lun jui 14 19:50:56 CEST 2003
       copyright                : (C) 2003 by Thomas Silvi
           email                : thomas.silvi@laposte.net
*********************************************************************************/

/********************************************************************************
*                                                                               *
*   This file is part of the Escort Tools Suite program.                        *
*                                                                               *
*   Escort Tools Suite is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by        *
*   the Free Software Foundation; either version 2 of the License, or           *
*   (at your option) any later version.                                         *
*                                                                               *
*   Escort Tools Suite is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
*   GNU General Public License for more details.                                *
*                                                                               *
*   You should have received a copy of the GNU General Public License           *
*   along with Escort Tools Suite; if not, write to the Free Software           *
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA   *
*                                                                               *
*********************************************************************************/

#include "OutputViewText.h"
#include "Misc.h"

#include <qdir.h>

extern QString applicationName;

OutputViewText::OutputViewText(QString const &pConnectionName) : OutputView()
{
	resultTextOutput = new KTextEdit(this);
	resultTextOutput->show();
//	resultTextOutput->adjustSize();
	connectionName = pConnectionName;
	connectionName.replace("/","_");

	initOutput();
}

bool OutputViewText::specialInit(QString &pErrorMessage)
{
	pErrorMessage = "";

	// check if tmp dir exists in user directory

	QString tmpPathStr, errorMessage, tmpFileTmpStr;

	tmpPathStr = "~/tmp";

	if (replaceTildaByHomeDirectory(tmpPathStr, pErrorMessage) == false)
	{
		return false;
	}

	QDir tmpAbsPath(tmpPathStr);

	if (tmpAbsPath.exists() == false)
	{
		if (tmpAbsPath.mkdir(tmpPathStr) == false)
		{
			pErrorMessage = QString("Error: can not create directory ") + tmpPathStr;
			return false;
		}
	}

	tmpPathStr += "/" + applicationName + "-tmp";

	QDir tmpAbsPath2(tmpPathStr);

	if (tmpAbsPath2.exists() == false)
	{
		if (tmpAbsPath2.mkdir(tmpPathStr) == false)
		{
			pErrorMessage = QString("Error: can not create directory ") + tmpPathStr;
			return false;
		}
	}
	sprintf(tmpFileName,"%s/%s.txt",tmpPathStr.ascii(),connectionName.ascii());
	
#ifdef DEBUG_APP
	printf("DEBUG_APP Temp file buffer : >%s<\n", tmpFileName);
#endif

	return true;
}

OutputViewText::~OutputViewText()
{
	if (resultTextOutput != 0)
	{
		delete resultTextOutput;
	}
}

void OutputViewText::printOutput(QString pStr)
{
	resultTextOutput->append(pStr);

	return;
}

void OutputViewText::saveOutput(QFile &pFile)
{
	QTextStream stream(&pFile);

	// we set this class not in read only temporary
	// in order the text function returns not empty string

	resultTextOutput->setReadOnly(FALSE);
	stream << resultTextOutput->text();
	resultTextOutput->setReadOnly(TRUE);

	return;
}

void OutputViewText::initOutput()
{
	resultTextOutput->setTextFormat(PlainText);
	resultTextOutput->setWordWrap(QTextEdit::NoWrap);
//	resultTextOutput->setReadOnly(TRUE);
	resultTextOutput->setReadOnly(FALSE);
	resultTextOutput->setCurrentFont(QFont("Courier",10));
	resultTextOutput->setPaletteBackgroundColor(QColor("white"));

	return;
}

void OutputViewText::resetOutput()
{
	resultTextOutput->clear();
	resultTextOutput->setTextFormat(PlainText);
	resultTextOutput->setCurrentFont(QFont("Courier",10));

	return;
}

void OutputViewText::showResuts(PGresult *pResults)
{
	// ToDo : find a way to print directly in the KTextEdit output
	FILE *out;
	PQprintOpt print_options;
	char buffer[1000];

	out = fopen(tmpFileName,"w+");

	if (out == 0)
	{
		printf ("PathFileName>%s<\n", tmpFileName);
		sprintf (buffer,"File error : errno %d",errno);

		app->lock(); 
		resultTextOutput->append(QString(buffer));
		app->unlock();

		return;
	}

	memset(&print_options, '\0', sizeof(print_options)); 
	print_options.header = 1; 
	print_options.align = 1; 
	print_options.html3 = 0; 
	print_options.fieldSep = "|"; 
	print_options.fieldName = 0; // alternate field names 
	PQprint(out,pResults, &print_options); 
	rewind(out);

	app->lock();

	while (!feof(out)) 
	{ 
		fgets(buffer,900,out); 
		resultTextOutput->append(QString(buffer)); 
	} 

	fclose(out); 
	resultTextOutput->update(); 
	app->unlock();

	remove(tmpFileName);

	return;
}

void OutputViewText::resizeEvent (QResizeEvent *e) 
{
	QFrame::resizeEvent(e);

	QSize s = this->size();

	resultTextOutput->setMinimumSize(s);
	resultTextOutput->setMaximumSize(s);

	return;
}


