/********************************************************************************
                                   Misc.cpp
                               -------------------
           begin                : lun jui 14 19:50:56 CEST 2003
       copyright                : (C) 2003 by Thomas Silvi
           email                : thomas.silvi@laposte.net
*********************************************************************************/

/********************************************************************************
*                                                                               *
*   This file is part of the Escort Tools Suite program.                        *
*                                                                               *
*   Escort Tools Suite is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by        *
*   the Free Software Foundation; either version 2 of the License, or           *
*   (at your option) any later version.                                         *
*                                                                               *
*   Escort Tools Suite is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
*   GNU General Public License for more details.                                *
*                                                                               *
*   You should have received a copy of the GNU General Public License           *
*   along with Escort Tools Suite; if not, write to the Free Software           *
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA   *
*                                                                               *
*********************************************************************************/

#include "Misc.h"

#include <unistd.h>
#include <pwd.h>

#include <klocale.h>

#include <qregexp.h>

bool isIP(QString const pStr)
{
	// return true if string represents an ip address
        bool result;
        QRegExp reIP("\\d\\d?\\d?.\\d\\d?\\d?.\\d\\d?\\d?.\\d\\d?\\d?");

        result = reIP.exactMatch(pStr);

        return result;
}

bool replaceTildaByHomeDirectory(QString  &pStr, QString &pErrorMessage)
{
	// return a string with the full path
	// the ~ is replaced by the user directory 
        QChar charHome('~');
        QString strHome;
        uid_t userId;
        struct passwd * pwTmp;

        pErrorMessage = "";

        if (pStr.at(0) != charHome)
        {
                // nothing to do
                return true;
        }

        userId = geteuid();
        pwTmp = getpwuid(userId);

        if (pwTmp ==0)
        {
                pErrorMessage = i18n("Can not get home directory.");
                return false;
        }

        strHome = QString(pwTmp->pw_dir);
        pStr.replace(0,1,strHome);

        return true;
}



