/********************************************************************************
                                ConfigDialog.cpp
                               -------------------
           begin                : lun jui 14 19:50:56 CEST 2003
       copyright                : (C) 2003 by Thomas Silvi
           email                : thomas.silvi@laposte.net
*********************************************************************************/

/********************************************************************************
*                                                                               *
*   This file is part of the Escort Tools Suite program.                        *
*                                                                               *
*   Escort Tools Suite is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by        *
*   the Free Software Foundation; either version 2 of the License, or           *
*   (at your option) any later version.                                         *
*                                                                               *
*   Escort Tools Suite is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
*   GNU General Public License for more details.                                *
*                                                                               *
*   You should have received a copy of the GNU General Public License           *
*   along with Escort Tools Suite; if not, write to the Free Software           *
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA   *
*                                                                               *
*********************************************************************************/

#include "ConfigDialog.h"

#include <klocale.h>

#include <qframe.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qcheckbox.h>
#include <qpushbutton.h>


ConfigDialog::ConfigDialog(QWidget *pParent, ToolSuiteConfig *pConfig) :
	KDialogBase (KDialogBase::TreeList, i18n("Configure ToolSuite"),
		KDialogBase::Ok|KDialogBase::Apply |KDialogBase::Cancel,
		KDialogBase::Ok, pParent, "ToolSuiteConfigurationDialog")

{
        bool boolTmp;
        unsigned int uintTmp;
        signed int rowTmp;

        config = pConfig;

        setMinimumSize(640,400);

        // General

        QFrame *pageGeneral = addPage(i18n("General"));
        QGridLayout *layoutGeneral = new QGridLayout(pageGeneral,10,10,6);

        rowTmp = 0;

                // Ask for showing ToolBar
        cbShowToolBar = new QCheckBox(i18n("Show ToolBar"), pageGeneral);
        layoutGeneral->addWidget(cbShowToolBar, rowTmp, 0);
        boolTmp = config->getBool("ShowToolBar");
        cbShowToolBar->setChecked(boolTmp);

        rowTmp++;


	// Query Tool -> Query/Batch Execution

        QFrame *pageQueryTool = addPage(i18n("Query Tool"));
        QGridLayout *layoutQueryTool = new QGridLayout(pageQueryTool,10,10,6);

        rowTmp = 0;

                // Auto switch to result

        cbAutoSwitchToResult = new QCheckBox(i18n("Auto switch to result"),
                pageQueryTool);
        layoutQueryTool->addWidget(cbAutoSwitchToResult, rowTmp, 0);
        boolTmp = config->getBool("AutoSwitchToResult");
        cbAutoSwitchToResult->setChecked(boolTmp);

        rowTmp++;

                // Batch execution continue on error

       cbBatchExecutionContinueOnError = new QCheckBox(
                i18n("Batch execution continue on error"), pageQueryTool);
        layoutQueryTool->addWidget(cbBatchExecutionContinueOnError, rowTmp, 0);
        boolTmp = config->getBool("BatchExecutionContinueOnError");
        cbBatchExecutionContinueOnError->setChecked(boolTmp);

        rowTmp++;

                // Ask for showing results with more thant n rows
        cbNRows = new QCheckBox(i18n("Prompt for showing result with more than n rows"),
                pageQueryTool);
        layoutQueryTool->addWidget(cbNRows, rowTmp, 0);
        boolTmp = config->getBool("PromptForShowingResultsWithMoreThanNRows");
        cbNRows->setChecked(boolTmp);

        niRows = new KIntNumInput(pageQueryTool);
        niRows->setMinValue(0);
        niRows->setLabel(QString("Rows"), AlignVCenter);
        layoutQueryTool->addWidget(niRows, rowTmp, 1);
        uintTmp = config->getUInt("NRows");
        niRows->setValue(uintTmp);

        rowTmp++;

                // Ask for clearing notices window for each batch execution

        cbClearNoticesOutput = new QCheckBox(i18n("Clear notices window for each batch execution"),
                pageQueryTool);
        layoutQueryTool->addWidget(cbClearNoticesOutput, rowTmp, 0);
        boolTmp = config->getBool("ClearNoticesOutput");
        cbClearNoticesOutput->setChecked(boolTmp);

        rowTmp++;

                // SameFileSaveLoad

        cbSameFileSaveLoad = new QCheckBox(i18n("If a file is previously loaded, save will update this file."), pageQueryTool);
        layoutQueryTool->addWidget(cbSameFileSaveLoad, rowTmp, 0);
        boolTmp = config->getBool("SameFileSaveLoad");
        cbSameFileSaveLoad->setChecked(boolTmp);

        rowTmp++;

		// Ask to set view configurations with configurations of the last view created

	cbSetViewCfgWithLastCreatedView = new QCheckBox(i18n("Set configuration for the new views with the configuration of the last created view"),
		pageQueryTool);
        layoutQueryTool->addWidget(cbSetViewCfgWithLastCreatedView, rowTmp, 0);
        boolTmp = config->getBool("SetViewCfgWithCfgLastViewCreated");
	cbSetViewCfgWithLastCreatedView->setChecked(boolTmp);
	
        rowTmp++;

        // Connection

        QFrame *pageConnection = addPage(i18n("Connection"));
        QGridLayout *layoutConnection = new QGridLayout(pageConnection,10,2,5);

        rowTmp = 0;

                // auto fill connection dialog box
                        // with PG Environment variable

        cbConFillEnvVarPG = new QCheckBox(
                i18n("Fill connection parameters with PG Environment variables"),
                pageConnection);
        layoutConnection->addWidget(cbConFillEnvVarPG, rowTmp, 0);
        cbConFillEnvVarPG->setChecked(config->getBool("FillConnParamWithPGEnvVariable"));

        rowTmp++;

                        // login = unix login
        cbConFillLoginWithUnixLogin = new QCheckBox(
                i18n("Fill login with unix login (if no PGUSER found or default user defined)"),
                         pageConnection);
        layoutConnection->addWidget(cbConFillLoginWithUnixLogin, rowTmp, 0);
        cbConFillLoginWithUnixLogin->setChecked(config->getBool("FillLoginWithUnixLogin"));

        rowTmp++;

			// use the parameter of the last active connection

        cbFillConnParamWithLastCreatedConnParam = new QCheckBox(
                i18n("Fill connection parameters with the parameters of the last created connection"),
                         pageConnection);
        layoutConnection->addWidget(cbFillConnParamWithLastCreatedConnParam, rowTmp, 0);
	cbFillConnParamWithLastCreatedConnParam->setChecked(config->getBool("FillConnParamWithLastActiveConnParam"));

        rowTmp++;

                        // define & force default

        // Input
        // Output
        // Notices


        // Startup

//      QFrame *page_startup = addPage(i18n("Startup"));

                // splash screen
                // use of .psqlrc

        showPage(0);

}

ConfigDialog::~ConfigDialog()
{
	config = 0;
}

void ConfigDialog::slotOk()
{
        applyChanges();
        config->save();
        close();
        return;
}

void ConfigDialog::slotApply()
{
        applyChanges();
//      close();
        return;
}

void ConfigDialog::applyChanges()
{
        unsigned int uiTmp;

        // General

        config->setBool("ShowToolBar", cbShowToolBar->isChecked());

	// QueryTool

        config->setBool("AutoSwitchToResult",
                cbAutoSwitchToResult->isChecked());

        config->setBool("BatchExecutionContinueOnError",
                cbBatchExecutionContinueOnError->isChecked());

        config->setBool("PromptForShowingResultsWithMoreThanNRows",
                cbNRows->isChecked());

        uiTmp = niRows->value();
        config->setUInt("NRows",uiTmp);

        config->setBool("ClearNoticesOutput", cbClearNoticesOutput->isChecked());

        config->setBool("SameFileSaveLoad", cbSameFileSaveLoad->isChecked());

	config->setBool("SetViewCfgWithCfgLastViewCreated",
		cbSetViewCfgWithLastCreatedView->isChecked());

        // Connection

        config->setBool("FillConnParamWithPGEnvVariable",
                cbConFillEnvVarPG->isChecked());

        config->setBool("FillLoginWithUnixLogin",
                cbConFillLoginWithUnixLogin->isChecked());

	config->setBool("FillConnParamWithLastActiveConnParam",
		cbFillConnParamWithLastCreatedConnParam->isChecked());

        return;
}


















