/********************************************************************************
                              BatchExecutorThread.h
                               -------------------
           begin                : lun jui 14 19:50:56 CEST 2003
       copyright                : (C) 2003 by Thomas Silvi
           email                : thomas.silvi@laposte.net
*********************************************************************************/

/********************************************************************************
*                                                                               *
*   This file is part of the Escort Tools Suite program.                        *
*                                                                               *
*   Escort Tools Suite is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by        *
*   the Free Software Foundation; either version 2 of the License, or           *
*   (at your option) any later version.                                         *
*                                                                               *
*   Escort Tools Suite is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
*   GNU General Public License for more details.                                *
*                                                                               *
*   You should have received a copy of the GNU General Public License           *
*   along with Escort Tools Suite; if not, write to the Free Software           *
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA   *
*                                                                               *
*********************************************************************************/

#ifndef BATCH_EXECUTOR_THREAD_H
#define BATCH_EXECUTOR_THREAD_H

#include "Batch.h"

// #include "QueryToolView.h"
#include "QueryEngine.h"
#include "ToolSuiteConfig.h"

#include <qthread.h>
#include <qobject.h>

class QueryToolView;

class BatchExecutorThread : public QObject, public QThread
{
	Q_OBJECT
	
	public:

	BatchExecutorThread();
	~BatchExecutorThread();
	
	virtual void run();
	
	void setBatch(Batch *pBatch);
	void setView(QueryToolView *pView);
	void setEngine(QueryEngine *pEngine);
	void setConfig(ToolSuiteConfig *pConfig);
	void cancelBatchExecution();
	Batch * getBatch();
	
	signals:
	
	void signalPrintOutput(QString pStr);
	void signalBatchExecuted();
	void signalShowResults(PGresult *pResults);
	void signalSwitchToOutput();
	
	protected:
	
	Batch *batch;
	QueryToolView *view;
	QueryEngine *engine;
	ToolSuiteConfig *config;
	bool isBatchCanceled;

};

#endif
