/*  Copyright (C) 2011 Ben Asselstine
 *  This file originates in the doodlehash project.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
 *  02110-1301, USA.
 */
#ifndef DOODLEHASH_EYEBROWS_H
#define DOODLEHASH_EYEBROWS_H

#include <glib.h>
#include <libdoodlehash/doodlehash-types.h>
#include <libdoodlehash/doodlehash-enums.h>

G_BEGIN_DECLS
typedef struct eyebrow
{
  DoodleHashObject *base;
  guint32 connect_to_eye_x;
  guint32 connect_to_eye_y;
}DoodleHashEyeBrow;

struct _DoodleHashEyeBrowPair
{
  DoodleHashEyeBrow *left;
  DoodleHashEyeBrow *right;
};

DoodleHashEyeBrowPair* doodlehash_eyebrows_new();
DoodleHashEyeBrowPair* doodlehash_eyebrows_copy(const DoodleHashEyeBrowPair *orig);
DoodleHashEyeBrowPair* doodlehash_eyebrows_load_from_svg_file(const gchar *left, const gchar *right);
void doodlehash_eyebrows_get_width_and_height(DoodleHashEyeBrowPair* eyebrows, guint side, guint32* width, guint32* height);
guint32 doodlehash_eyebrows_get_width(DoodleHashEyeBrowPair* eyebrows, guint side);
guint32 doodlehash_eyebrows_get_height(DoodleHashEyeBrowPair* eyebrows, guint side);
void doodlehash_eyebrows_set_width(DoodleHashEyeBrowPair* eyebrows, guint side, guint32 width);
void doodlehash_eyebrows_set_height(DoodleHashEyeBrowPair* eyebrows, guint side, guint32 height);
void doodlehash_eyebrows_get_eye_connection_point(DoodleHashEyeBrowPair* eyebrows, guint side, guint32* x, guint32* y);
guint32 doodlehash_eyebrows_get_eye_connection_point_x(DoodleHashEyeBrowPair* eyebrows, guint side);
guint32 doodlehash_eyebrows_get_eye_connection_point_y(DoodleHashEyeBrowPair* eyebrows, guint side);
void doodlehash_eyebrows_set_eye_connection_point(DoodleHashEyeBrowPair* eyebrows, guint side, guint32 x, guint32 y);
void doodlehash_eyebrows_set_random_colours(DoodleHashEyeBrowPair* eyebrows, guint code, int matching);
void doodlehash_eyebrows_set_colours(DoodleHashEyeBrowPair* eyebrows, guint side, guint code, char *stroke_colour, char *fill_colour);
gchar *doodlehash_eyebrows_get_fill_colour(DoodleHashEyeBrowPair* eyebrows, guint side, guint code);
gchar *doodlehash_eyebrows_get_stroke_colour(DoodleHashEyeBrowPair* eyebrows, guint side, guint code);
void doodlehash_eyebrows_scale(DoodleHashEyeBrowPair *eyebrows, guint side, double scale);
void doodlehash_eyebrows_free(DoodleHashEyeBrowPair* eyebrows);

G_END_DECLS
#endif /* DOODLEHASH_EYEBROWS_H */
