/*  Copyright (C) 2011 Ben Asselstine
 *  This file originates in the doodlehash project.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
 *  02110-1301, USA.
 */
#ifndef DOODLEHASH_EARS_H
#define DOODLEHASH_EARS_H

#include <glib.h>
#include <libdoodlehash/doodlehash-types.h>
#include <libdoodlehash/doodlehash-enums.h>

G_BEGIN_DECLS
typedef struct
{
  DoodleHashObject *base;
  guint32 connect_to_head_x;
  guint32 connect_to_head_y;
  guint32 connect_to_earring_x;
  guint32 connect_to_earring_y;
}DoodleHashEar;

struct _DoodleHashEarPair
{
  DoodleHashEar *left;
  DoodleHashEar *right;
};

DoodleHashEarPair* doodlehash_ears_new();
DoodleHashEarPair* doodlehash_ears_copy(const DoodleHashEarPair *orig);
DoodleHashEarPair* doodlehash_ears_load_from_svg_file(const gchar *left, const gchar *right);
void doodlehash_ears_get_width_and_height(DoodleHashEarPair* ear, guint side, guint32* width, guint32* height);
guint32 doodlehash_ears_get_width(DoodleHashEarPair* ear, guint side);
guint32 doodlehash_ears_get_height(DoodleHashEarPair* ear, guint side);
void doodlehash_ears_set_width(DoodleHashEarPair* ear, guint side, guint32 width);
void doodlehash_ears_set_height(DoodleHashEarPair* ear, guint side, guint32 height);
void doodlehash_ears_get_head_connection_point(DoodleHashEarPair* ear, guint side, guint32* x, guint32* y);
guint32 doodlehash_ears_get_head_connection_point_x(DoodleHashEarPair* ear, guint side);
guint32 doodlehash_ears_get_head_connection_point_y(DoodleHashEarPair* ear, guint side);
void doodlehash_ears_set_head_connection_point(DoodleHashEarPair* ear, guint side, guint32 x, guint32 y);
void doodlehash_ears_get_earring_connection_point(DoodleHashEarPair* ear, guint side, guint32* x, guint32* y);
guint32 doodlehash_ears_get_earring_connection_point_x(DoodleHashEarPair* ear, guint side);
guint32 doodlehash_ears_get_earring_connection_point_y(DoodleHashEarPair* ear, guint side);
void doodlehash_ears_set_earring_connection_point(DoodleHashEarPair* ear, guint side, guint32 x, guint32 y);
void doodlehash_ears_set_random_colours(DoodleHashEarPair* ear, guint code, int matearsg);
void doodlehash_ears_set_colours(DoodleHashEarPair* ear, guint side, guint code, char *stroke_colour, char *fill_colour);
gchar *doodlehash_ears_get_fill_colour(DoodleHashEarPair* ear, guint side, guint code);
gchar *doodlehash_ears_get_stroke_colour(DoodleHashEarPair* ear, guint side, guint code);
void doodlehash_ears_scale(DoodleHashEarPair *ear, guint side, double scale);
void doodlehash_ears_free(DoodleHashEarPair* ear);
G_END_DECLS

#endif /* DOODLEHASH_EARS_H */
