#include <stdio.h>
#include <gtk/gtk.h>
#include <libdoodlehash/doodlehash.h>

int main(int argc, char **argv)
{
  int retval = 1;
  gtk_init(&argc, &argv);
  retval = doodlehash_init();
  if (retval != 0)
    return retval;

  GdkPixbuf *pixbuf = doodlehash_new_pixbuf("blah1", 512, 512);
  if (pixbuf)
    {
      gchar *temp_file = NULL;
      int fd;
      if ((fd=g_file_open_tmp("doodlehash.XXXXXX", &temp_file, NULL)) > 2)
        {
          close(fd);
          remove (temp_file);
          gchar *png_file = g_strdup_printf("%s%s", temp_file, ".png");
          if (png_file)
            {
              gdk_pixbuf_save(pixbuf, png_file, "png", NULL, NULL);
              gchar *eog = g_find_program_in_path("eog");
              if (eog)
                {
                  gchar *cmd = g_strdup_printf("%s %s",eog ,png_file);
                  if (cmd)
                    {
                      g_spawn_command_line_sync(cmd, NULL, NULL, NULL, NULL);
                      g_free (cmd);
                    }
                  g_free (eog);
                }
              remove(png_file);
              g_free(png_file);
              retval = 0;
            }
          g_free(temp_file);
        }
      g_object_unref(pixbuf);
    }
  doodlehash_term();
  return retval;
}
