/*  Copyright (C) 2011 Ben Asselstine
 *  This file originates in the doodlehash project.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope teyes it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
 *  02110-1301, USA.
 */
#ifndef DOODLEHASH_EYES_H
#define DOODLEHASH_EYES_H

#include <glib.h>
#include <libdoodlehash/doodlehash-types.h>
#include <libdoodlehash/doodlehash-enums.h>

G_BEGIN_DECLS
struct _DoodleHashEyes
{
  DoodleHashObject *base;
  guint32 connect_to_head_x;
  guint32 connect_to_head_y;
  guint32 connect_to_left_brow_x;
  guint32 connect_to_left_brow_y;
  guint32 connect_to_right_brow_x;
  guint32 connect_to_right_brow_y;
};

DoodleHashEyes* doodlehash_eyes_new();
DoodleHashEyes* doodlehash_eyes_copy(const DoodleHashEyes*orig);
DoodleHashEyes* doodlehash_eyes_load_from_svg_file(const char *file);
void doodlehash_eyes_get_width_and_height(DoodleHashEyes* eyes, guint32* width, guint32* height);
guint32 doodlehash_eyes_get_width(DoodleHashEyes* eyes);
guint32 doodlehash_eyes_get_height(DoodleHashEyes* eyes);
void doodlehash_eyes_set_width(DoodleHashEyes* eyes, guint32 width);
void doodlehash_eyes_set_height(DoodleHashEyes* eyes, guint32 height);
void doodlehash_eyes_get_head_connection_point(DoodleHashEyes* eyes, guint32* x, guint32* y);
guint32 doodlehash_eyes_get_head_connection_point_x(DoodleHashEyes* eyes);
guint32 doodlehash_eyes_get_head_connection_point_y(DoodleHashEyes* eyes);
void doodlehash_eyes_set_head_connection_point(DoodleHashEyes* eyes, guint32 x, guint32 y);
guint32 doodlehash_eyes_get_left_brow_connection_point_x(DoodleHashEyes* eyes);
guint32 doodlehash_eyes_get_left_brow_connection_point_y(DoodleHashEyes* eyes);
void doodlehash_eyes_get_left_brow_connection_point(DoodleHashEyes* eyes, guint32* x, guint32* y);
void doodlehash_eyes_set_left_brow_connection_point(DoodleHashEyes* eyes, guint32 x, guint32 y);
guint32 doodlehash_eyes_get_left_brow_connection_point_x(DoodleHashEyes* eyes);
guint32 doodlehash_eyes_get_left_brow_connection_point_y(DoodleHashEyes* eyes);
guint32 doodlehash_eyes_get_right_brow_connection_point_x(DoodleHashEyes* eyes);
guint32 doodlehash_eyes_get_right_brow_connection_point_y(DoodleHashEyes* eyes);
void doodlehash_eyes_get_right_brow_connection_point(DoodleHashEyes* eyes, guint32* x, guint32* y);
void doodlehash_eyes_set_right_brow_connection_point(DoodleHashEyes* eyes, guint32 x, guint32 y);
guint32 doodlehash_eyes_get_right_brow_connection_point_x(DoodleHashEyes* eyes);
guint32 doodlehash_eyes_get_right_brow_connection_point_y(DoodleHashEyes* eyes);
void doodlehash_eyes_set_random_colours(DoodleHashEyes* eyes, guint code);
void doodlehash_eyes_set_colours(DoodleHashEyes* eyes, guint code, char *stroke_colour, char *fill_colour);
gchar *doodlehash_eyes_get_fill_colour(DoodleHashEyes* eyes, guint code);
gchar *doodlehash_eyes_get_stroke_colour(DoodleHashEyes* eyes, guint code);
void doodlehash_eyes_scale(DoodleHashEyes *eyes, double scale);
void doodlehash_eyes_free(DoodleHashEyes* eyes);

G_END_DECLS
#endif /* DOODLEHASH_EYES_H */
