/*  Copyright (C) 2011 Ben Asselstine
 *  This file originates in the doodlehash project.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
 *  02110-1301, USA.
 */
#include <config.h>
#include "spectacles.h"
#include <libxml/tree.h>
#include <glib.h>
#include <string.h>
#include "util.h"
#include "object.h"
DoodleHashSpectacles* doodlehash_spectacles_new()
{
  DoodleHashSpectacles *h = g_malloc (sizeof (DoodleHashSpectacles));
  if (!h)
    return NULL;
  memset (h, 0, sizeof (DoodleHashSpectacles));
  h->base = doodlehash_object_new();
  return h;
}

DoodleHashSpectacles* doodlehash_spectacles_copy(const DoodleHashSpectacles*orig)
{
  DoodleHashSpectacles *spectacles = doodlehash_spectacles_new();
  g_free (spectacles->base);
  spectacles->base = doodlehash_object_copy(orig->base);
  return spectacles;
}

DoodleHashSpectacles* doodlehash_spectacles_load_from_svg_file(const char *file)
{
  DoodleHashSpectacles* spectacles = doodlehash_spectacles_new();
  if (doodlehash_object_load_from_svg_file(spectacles->base, file) != 0)
    {
      doodlehash_spectacles_free (spectacles);
      return NULL;
    }
  return spectacles;
}

void doodlehash_spectacles_get_width_and_height(DoodleHashSpectacles* spectacles, guint32* width, guint32* height)
{
  doodlehash_object_get_width_and_height(spectacles->base, width, height);
}

guint32 doodlehash_spectacles_get_width(DoodleHashSpectacles* spectacles)
{
  return doodlehash_object_get_width(spectacles->base);
}

guint32 doodlehash_spectacles_get_height(DoodleHashSpectacles* spectacles)
{
  return doodlehash_object_get_height(spectacles->base);
}

void doodlehash_spectacles_set_width(DoodleHashSpectacles* spectacles, guint32 width)
{
  double scale = (double) width / (double)spectacles->base->width;
  doodlehash_object_set_width(spectacles->base, spectacles->base->width * scale);
}

void doodlehash_spectacles_set_height(DoodleHashSpectacles* spectacles, guint32 height)
{
  double scale = (double) height / (double)spectacles->base->height;
  doodlehash_object_set_height(spectacles->base, spectacles->base->height * scale);
}

void doodlehash_spectacles_set_random_colours(DoodleHashSpectacles* spectacles, guint code)
{
  doodlehash_object_set_random_colours(spectacles->base, code);
}
void doodlehash_spectacles_set_colours(DoodleHashSpectacles* spectacles, guint code, char *s, char *f)
{
  doodlehash_object_set_colours(spectacles->base, code, s, f);
}

gchar *doodlehash_spectacles_get_fill_colour(DoodleHashSpectacles* spectacles, guint code)
{
  return doodlehash_object_get_fill_colour(spectacles->base, code);
}

gchar *doodlehash_spectacles_get_stroke_colour(DoodleHashSpectacles* spectacles, guint code)
{
  return doodlehash_object_get_stroke_colour(spectacles->base, code);
}

void doodlehash_spectacles_scale(DoodleHashSpectacles *spectacles, double scale)
{
  doodlehash_object_scale(spectacles->base, scale);
}
void doodlehash_spectacles_free(DoodleHashSpectacles* s)
{
  if (s && s->base)
    doodlehash_object_free (s->base);
  g_free (s);
}
